/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimatorCache;
import org.neo4j.memory.HeapEstimatorCacheConfig;
import org.neo4j.memory.Measurable;
import org.neo4j.util.VisibleForTesting;

public class DeduplicateLargeObjectsHeapEstimatorCache
implements HeapEstimatorCache {
    public static final int MAX_CACHE_HITS = 1000000;
    public static final boolean DEBUG_LOG_ENABLED = false;
    private final int sizeLimit;
    private final long largeObjectThreshold;
    private final Measurable[] cacheRefs;
    private final long[] cacheEstimates;
    private final int[] cacheHits;
    private int currentSize;

    public DeduplicateLargeObjectsHeapEstimatorCache(HeapEstimatorCacheConfig config) {
        this(config.sizeLimit(), config.largeObjectThreshold());
    }

    DeduplicateLargeObjectsHeapEstimatorCache(int sizeLimit, long largeObjectThreshold) {
        this.sizeLimit = sizeLimit;
        this.largeObjectThreshold = largeObjectThreshold;
        this.cacheRefs = new Measurable[sizeLimit];
        this.cacheEstimates = new long[sizeLimit];
        this.cacheHits = new int[sizeLimit];
    }

    public DeduplicateLargeObjectsHeapEstimatorCache() {
        this(HeapEstimatorCacheConfig.DEFAULT);
    }

    @Override
    public long estimatedHeapUsage(Measurable measurable, long estimate) {
        if (estimate < this.largeObjectThreshold) {
            return estimate;
        }
        int index = this.find(measurable, estimate);
        if (index >= 0) {
            return 0L;
        }
        this.insert(measurable, estimate);
        return estimate;
    }

    @Override
    public void fastReset() {
        this.currentSize = 0;
    }

    @Override
    public void fullReset() {
        Arrays.fill(this.cacheRefs, 0, this.currentSize, null);
        this.currentSize = 0;
    }

    @Override
    public HeapEstimatorCache newWithSameSettings() {
        return new DeduplicateLargeObjectsHeapEstimatorCache(this.sizeLimit, this.largeObjectThreshold);
    }

    public String toString() {
        return String.format("%s:%08x,size:%d,thres:%d", this.getClass().getSimpleName(), System.identityHashCode(this), this.sizeLimit, this.largeObjectThreshold);
    }

    private int find(Measurable measurable, long estimate) {
        for (int i = 0; i < this.currentSize; ++i) {
            if (this.cacheRefs[i] != measurable) continue;
            int newHits = this.cacheHits[i] + 1;
            if (newHits < 1000000) {
                this.cacheHits[i] = newHits;
            }
            return i;
        }
        return -1;
    }

    private void insert(Measurable measurable, long estimate) {
        int size;
        if ((size = this.currentSize++) < this.sizeLimit) {
            this.cacheRefs[size] = measurable;
            this.cacheEstimates[size] = estimate;
            this.cacheHits[size] = 1;
        } else {
            this.evictAndReplace(measurable, estimate, size);
        }
    }

    private void evictAndReplace(Measurable measurable, long estimate, int size) {
        int minHitsIndex = 0;
        int minHits = this.cacheHits[0];
        long minHitsEstimate = this.cacheEstimates[0];
        for (int i = 1; i < size; ++i) {
            long cachedEstimate;
            int hits = this.cacheHits[i];
            if (hits < minHits) {
                minHitsIndex = i;
                minHits = hits;
                minHitsEstimate = this.cacheEstimates[i];
                continue;
            }
            if (hits != minHits || (cachedEstimate = this.cacheEstimates[i]) >= minHitsEstimate) continue;
            minHitsIndex = i;
            minHitsEstimate = cachedEstimate;
        }
        this.cacheRefs[minHitsIndex] = measurable;
        this.cacheEstimates[minHitsIndex] = estimate;
        this.cacheHits[minHitsIndex] = 1;
    }

    @VisibleForTesting
    public static String refString(Measurable measurable) {
        return String.format("%s:%08x", measurable.getClass().getName(), System.identityHashCode(measurable));
    }

    private static void log(String format, Object ... args) {
    }
}

