/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NormalizedCatalogEntry {
    private final Optional<String> compositeDb;
    private final String databaseAlias;

    public NormalizedCatalogEntry(String compositeDb, String databaseAlias) {
        this.compositeDb = Optional.of(compositeDb.toLowerCase());
        this.databaseAlias = databaseAlias.toLowerCase();
    }

    public NormalizedCatalogEntry(String databaseAlias) {
        this.compositeDb = Optional.empty();
        this.databaseAlias = databaseAlias.toLowerCase();
    }

    public static NormalizedCatalogEntry fromList(List<String> nameParts) {
        if (nameParts.size() == 2) {
            return new NormalizedCatalogEntry(nameParts.get(0), nameParts.get(1));
        }
        if (nameParts.size() == 1) {
            return new NormalizedCatalogEntry(nameParts.get(0));
        }
        throw new IllegalStateException("a database alias should not consist of more than 2 parts");
    }

    public Optional<String> compositeDb() {
        return this.compositeDb;
    }

    public String databaseAlias() {
        return this.databaseAlias;
    }

    public String stringRepresentation() {
        return this.compositeDb.map(s -> s + "." + this.databaseAlias).orElse(this.databaseAlias);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NormalizedCatalogEntry)) return false;
        NormalizedCatalogEntry other = (NormalizedCatalogEntry)obj;
        if (!Objects.equals(this.compositeDb, other.compositeDb)) return false;
        if (!Objects.equals(this.databaseAlias, other.databaseAlias)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.compositeDb, this.databaseAlias);
    }
}

