/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.util.Preconditions;

public final class MathUtil {
    public static final double DEFAULT_EPSILON = 1.0E-8;
    private static final long NON_DOUBLE_LONG = -9007199254740992L;

    private MathUtil() {
        throw new AssertionError();
    }

    public static int clamp(int value, int lowerBound, int upperBound) {
        Preconditions.checkArgument(lowerBound <= upperBound, "given lower bound, %d; is greater than given upper bound, %d.", lowerBound, upperBound);
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static long clamp(long value, long lowerBound, long upperBound) {
        Preconditions.checkArgument(lowerBound <= upperBound, "given lower bound, %d; is greater than given upper bound, %d.", lowerBound, upperBound);
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static float clamp(float value, float lowerBound, float upperBound) {
        Preconditions.checkArgument(lowerBound <= upperBound, "given lower bound, %g; is greater than given upper bound, %g.", Float.valueOf(lowerBound), Float.valueOf(upperBound));
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static double clamp(double value, double lowerBound, double upperBound) {
        Preconditions.checkArgument(lowerBound <= upperBound, "given lower bound, %g; is greater than given upper bound, %g.", lowerBound, upperBound);
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static double portion(double ... n) {
        assert (n.length > 0);
        double first = n[0];
        if (Math.abs(first) < 1.0E-8) {
            return 0.0;
        }
        double total = Arrays.stream(n).sum();
        return first / total;
    }

    public static int compareDoubleAgainstLong(double lhs, long rhs) {
        if ((0xFFE0000000000000L & rhs) != -9007199254740992L) {
            if (Double.isNaN(lhs)) {
                return 1;
            }
            if (Double.isInfinite(lhs)) {
                return lhs < 0.0 ? -1 : 1;
            }
            return BigDecimal.valueOf(lhs).compareTo(BigDecimal.valueOf(rhs));
        }
        return Double.compare(lhs, rhs);
    }

    public static int decrementExactNotPastZero(int value) {
        if (value == 0) {
            throw new ArithmeticException("integer underflow past zero");
        }
        return value - 1;
    }

    public static int compare(double x, double y, double eps) {
        return MathUtil.equals(x, y, eps) ? 0 : (x < y ? -1 : 1);
    }

    public static boolean equals(double x, double y, double eps) {
        return Math.abs(x - y) <= eps;
    }

    public static class CommonToleranceComparator
    implements Comparator<Double> {
        private final double epsilon;

        public CommonToleranceComparator(double epsilon) {
            this.epsilon = epsilon;
        }

        @Override
        public int compare(Double x, Double y) {
            return MathUtil.compare(x, y, this.epsilon);
        }
    }
}

