/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPoolImpl;

class MemoryPoolImplTest {
    MemoryPoolImplTest() {
    }

    @Test
    void unboundedShouldBeUnbounded() {
        MemoryPoolImpl memoryPool = new MemoryPoolImpl(0L, false, null);
        memoryPool.reserveHeap(0x7FFFFFFFFFFFFFFEL);
        Assertions.assertEquals((long)1L, (long)memoryPool.free());
        memoryPool.releaseHeap(0x7FFFFFFFFFFFFFFDL);
        Assertions.assertEquals((long)1L, (long)memoryPool.usedHeap());
    }

    @Test
    void trackHeapAndNativeMemory() {
        MemoryPoolImpl memoryPool = new MemoryPoolImpl(1000L, true, null);
        memoryPool.reserveHeap(10L);
        Assertions.assertEquals((long)0L, (long)memoryPool.usedNative());
        Assertions.assertEquals((long)10L, (long)memoryPool.usedHeap());
        Assertions.assertEquals((long)10L, (long)memoryPool.totalUsed());
        Assertions.assertEquals((long)990L, (long)memoryPool.free());
        memoryPool.reserveNative(200L);
        Assertions.assertEquals((long)200L, (long)memoryPool.usedNative());
        Assertions.assertEquals((long)10L, (long)memoryPool.usedHeap());
        Assertions.assertEquals((long)210L, (long)memoryPool.totalUsed());
        Assertions.assertEquals((long)790L, (long)memoryPool.free());
    }

    @Test
    void nonStrictPoolAllowAllocationsOverMax() {
        MemoryPoolImpl memoryPool = new MemoryPoolImpl(10L, false, null);
        Assertions.assertDoesNotThrow(() -> memoryPool.reserveHeap(100L));
        Assertions.assertDoesNotThrow(() -> memoryPool.reserveHeap(100L));
        Assertions.assertDoesNotThrow(() -> memoryPool.reserveHeap(100L));
        Assertions.assertEquals((long)300L, (long)memoryPool.totalUsed());
    }

    @Test
    void strictPoolForbidAllocationsOverMax() {
        MemoryPoolImpl memoryPool = new MemoryPoolImpl(100L, true, null);
        Assertions.assertDoesNotThrow(() -> memoryPool.reserveHeap(10L));
        Assertions.assertThrows(MemoryLimitExceededException.class, () -> memoryPool.reserveHeap(100L));
        Assertions.assertDoesNotThrow(() -> memoryPool.reserveHeap(10L));
        Assertions.assertEquals((long)20L, (long)memoryPool.totalUsed());
    }

    @Test
    void freeShouldNotBeNegativeWhenPoolUsingMoreThenALimit() {
        MemoryPoolImpl memoryPool = new MemoryPoolImpl(10L, false, null);
        memoryPool.reserveHeap(9L);
        Assertions.assertEquals((long)1L, (long)memoryPool.free());
        memoryPool.reserveHeap(1L);
        Assertions.assertEquals((long)0L, (long)memoryPool.free());
        memoryPool.reserveHeap(10L);
        Assertions.assertEquals((long)0L, (long)memoryPool.free());
        Assertions.assertEquals((long)20L, (long)memoryPool.usedHeap());
    }

    @Test
    void imposeLimit() {
        long limit = 10L;
        long halfLimit = 5L;
        MemoryPoolImpl memoryPool = new MemoryPoolImpl(10L, true, "mySetting");
        MemoryPoolImplTest.assertState(10L, 10L, 0L, (MemoryPool)memoryPool);
        memoryPool.reserveHeap(5L);
        MemoryPoolImplTest.assertState(10L, 5L, 5L, (MemoryPool)memoryPool);
        memoryPool.reserveHeap(5L);
        MemoryPoolImplTest.assertState(10L, 0L, 10L, (MemoryPool)memoryPool);
        MemoryLimitExceededException memoryLimitExceededException = (MemoryLimitExceededException)Assertions.assertThrows(MemoryLimitExceededException.class, () -> MemoryPoolImplTest.lambda$imposeLimit$6((MemoryPool)memoryPool));
        AssertionsForInterfaceTypes.assertThat((String)memoryLimitExceededException.getMessage()).contains(new CharSequence[]{"The allocation of an extra 1 B would use more than the limit 10 B. Currently using 10 B"});
        AssertionsForInterfaceTypes.assertThat((String)memoryLimitExceededException.getMessage()).contains(new CharSequence[]{"mySetting"});
        memoryPool.releaseHeap(5L);
        MemoryPoolImplTest.assertState(10L, 5L, 5L, (MemoryPool)memoryPool);
        memoryPool.reserveHeap(1L);
        MemoryPoolImplTest.assertState(10L, 4L, 6L, (MemoryPool)memoryPool);
    }

    private static void assertState(long available, long free, long used, MemoryPool memoryPool) {
        Assertions.assertEquals((long)available, (long)memoryPool.totalSize());
        Assertions.assertEquals((long)free, (long)memoryPool.free());
        Assertions.assertEquals((long)used, (long)memoryPool.usedHeap());
    }

    private static /* synthetic */ void lambda$imposeLimit$6(MemoryPool memoryPool) throws Throwable {
        memoryPool.reserveHeap(1L);
    }
}

