/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Format;

class FormatTest {
    FormatTest() {
    }

    @Test
    void shouldDisplayPlainCount() {
        String format = Format.count((long)10L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("10"));
    }

    @Test
    void shouldDisplayThousandCount() {
        String format = Format.count((long)2000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("k"));
    }

    @Test
    void shouldDisplayMillionCount() {
        String format = Format.count((long)2000000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("M"));
    }

    @Test
    void shouldDisplayBillionCount() {
        String format = Format.count((long)2000000000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("G"));
    }

    @Test
    void shouldDisplayTrillionCount() {
        String format = Format.count((long)4000000000000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("4"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("T"));
    }

    @Test
    void displayDuration() {
        Assertions.assertThat((String)Format.duration((long)(TimeUnit.MINUTES.toMillis(1L) + TimeUnit.SECONDS.toMillis(2L)))).isEqualTo("1m 2s");
        Assertions.assertThat((String)Format.duration((long)42L)).isEqualTo("42ms");
        Assertions.assertThat((String)Format.duration((long)0L)).isEqualTo("0ms");
    }

    @Test
    void displayDate() throws ParseException {
        long timeWithDate = System.currentTimeMillis();
        String dateAsString = Format.date((long)timeWithDate);
        org.junit.jupiter.api.Assertions.assertEquals((long)timeWithDate, (long)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").parse(dateAsString).getTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2017-04-05 00:00:00.000+0000", (Object)Format.date((Instant)LocalDate.of(2017, 4, 5).atStartOfDay(ZoneOffset.UTC).toInstant()));
    }

    @Test
    void displayTime() throws ParseException {
        long timeWithDate = System.currentTimeMillis();
        String timeAsString = Format.time((long)timeWithDate);
        org.junit.jupiter.api.Assertions.assertEquals((long)timeWithDate, (long)FormatTest.translateToDate(timeWithDate, new SimpleDateFormat("HH:mm:ss.SSS").parse(timeAsString).getTime(), TimeZone.getTimeZone(Format.DEFAULT_TIME_ZONE)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2017-04-05 06:07:08.000+0000", (Object)Format.date((Instant)LocalDateTime.of(2017, 4, 5, 6, 7, 8, 9).toInstant(ZoneOffset.UTC)));
    }

    @Test
    void numberToStringWithGroups() {
        long number1 = 123456789L;
        long number2 = 10000L;
        String number1AsString = Format.numberToStringWithGroups((long)number1, (char)',');
        String number2AsString = Format.numberToStringWithGroups((long)number2, (char)'.');
        Assertions.assertThat((String)number1AsString).isEqualTo("123,456,789");
        Assertions.assertThat((String)number2AsString).isEqualTo("10.000");
    }

    private static long translateToDate(long timeWithDate, long time, TimeZone timeIsGivenInThisTimeZone) {
        Calendar calendar = Calendar.getInstance(timeIsGivenInThisTimeZone);
        calendar.setTimeInMillis(timeWithDate);
        Calendar timeCalendar = Calendar.getInstance();
        timeCalendar.setTimeInMillis(time);
        timeCalendar.setTimeZone(timeIsGivenInThisTimeZone);
        timeCalendar.set(1, calendar.get(1));
        timeCalendar.set(2, calendar.get(2));
        boolean crossedDayBoundary = !Format.DEFAULT_TIME_ZONE.equals(timeIsGivenInThisTimeZone.toZoneId()) && timeCalendar.get(11) < calendar.get(11);
        timeCalendar.set(5, calendar.get(5) + (crossedDayBoundary ? 1 : 0));
        return timeCalendar.getTimeInMillis();
    }
}

