/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.DefaultIntervalStrategy;
import org.neo4j.internal.helpers.IntervalStrategy;

class DefaultIntervalStrategyTest {
    DefaultIntervalStrategyTest() {
    }

    @Test
    void shouldFailIfPassedFunctionIsNotIncreasing() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultIntervalStrategy(0L, 100L, TimeUnit.MILLISECONDS, i -> i - 1L));
    }

    @Test
    void shouldGetAndIncrementCorrectly() {
        DefaultIntervalStrategy strategy = new DefaultIntervalStrategy(0L, 100L, TimeUnit.MILLISECONDS, i -> i + 1L);
        IntervalStrategy.IntervalProvider backoff = strategy.newIntervalProvider();
        Assertions.assertEquals((long)0L, (long)backoff.getAndIncrement());
        Assertions.assertEquals((long)1L, (long)backoff.getAndIncrement());
        Assertions.assertEquals((long)2L, (long)backoff.getMillis());
        IntervalStrategy.IntervalProvider backoff1 = strategy.newIntervalProvider();
        Assertions.assertEquals((long)0L, (long)backoff1.getMillis());
    }
}

