/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class GlobalMemoryGroupTrackerTest {
    private final GlobalMemoryGroupTracker globalPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 100L, null);

    GlobalMemoryGroupTrackerTest() {
    }

    @Test
    void trackedHeapFromTrackerAndPoolMatch() {
        MemoryTracker memoryTracker = this.globalPool.getPoolMemoryTracker();
        memoryTracker.allocateHeap(12L);
        Assertions.assertEquals((long)12L, (long)this.globalPool.usedHeap());
        Assertions.assertEquals((long)12L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void trackedNativeFromTrackerAndPoolMatch() {
        MemoryTracker memoryTracker = this.globalPool.getPoolMemoryTracker();
        memoryTracker.allocateNative(13L);
        Assertions.assertEquals((long)13L, (long)this.globalPool.usedNative());
        Assertions.assertEquals((long)13L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackedHeapFromPoolAndTrackerMatch() {
        MemoryTracker memoryTracker = this.globalPool.getPoolMemoryTracker();
        this.globalPool.reserveHeap(12L);
        Assertions.assertEquals((long)12L, (long)this.globalPool.usedHeap());
        Assertions.assertEquals((long)12L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void trackedNativeFromPoolAndTrackerMatch() {
        MemoryTracker memoryTracker = this.globalPool.getPoolMemoryTracker();
        this.globalPool.reserveNative(13L);
        Assertions.assertEquals((long)13L, (long)this.globalPool.usedNative());
        Assertions.assertEquals((long)13L, (long)memoryTracker.usedNativeMemory());
    }
}

