/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameUtil {
    private static final String BACKTICK = "`";
    private static final String BACKTICK_ESCAPED = "``";
    private static final Pattern BACKTICK_UNICODE_ESCAPED = Pattern.compile("\\\\u+0060");
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("^[\\p{L}_][\\p{L}0-9_]*");
    private static final Pattern GLOB = Pattern.compile("^[\\p{L}_?*][\\p{L}0-9_*?.]*");

    private NameUtil() {
    }

    public static String escapeBackticks(String string) {
        return BACKTICK_UNICODE_ESCAPED.matcher(string).replaceAll(BACKTICK).replace(BACKTICK, BACKTICK_ESCAPED);
    }

    public static String forceEscapeName(String string) {
        return BACKTICK + NameUtil.escapeBackticks(string) + BACKTICK;
    }

    public static String escapeName(String string) {
        return NameUtil.escape(ALPHA_NUMERIC, string);
    }

    public static String escapeGlob(String string) {
        return NameUtil.escape(GLOB, string);
    }

    private static String escape(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return NameUtil.forceEscapeName(string);
        }
        return string;
    }
}

