/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.DefaultTimeoutStrategy;
import org.neo4j.internal.helpers.TimeoutStrategy;

class ExponentialBackoffStrategyTest {
    private static final int NUMBER_OF_ACCESSES = 5;

    ExponentialBackoffStrategyTest() {
    }

    @Test
    void shouldDoubleEachTime() {
        DefaultTimeoutStrategy strategy = DefaultTimeoutStrategy.exponential((long)1L, (long)32L, (TimeUnit)TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assertions.assertEquals((long)32L, (long)timeout.getMillis());
    }

    @Test
    void shouldProvidePreviousTimeout() {
        DefaultTimeoutStrategy strategy = DefaultTimeoutStrategy.exponential((long)1L, (long)32L, (TimeUnit)TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assertions.assertEquals((long)32L, (long)timeout.getMillis());
    }

    @Test
    void shouldRespectUpperBound() {
        long upperBound = 27L;
        DefaultTimeoutStrategy strategy = DefaultTimeoutStrategy.exponential((long)1L, (long)upperBound, (TimeUnit)TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assertions.assertEquals((long)upperBound, (long)timeout.getMillis());
        timeout.increment();
        timeout.increment();
        timeout.increment();
        Assertions.assertEquals((long)upperBound, (long)timeout.getMillis());
    }
}

