/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.util.Preconditions;

class PreconditionsTest {
    PreconditionsTest() {
    }

    @Test
    void requirePositiveOk() {
        Preconditions.requirePositive((int)1);
    }

    @Test
    void requirePositiveFailsOnZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requirePositive((int)0));
    }

    @Test
    void requirePositiveFailsOnNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requirePositive((int)-1));
    }

    @Test
    void requireNonNegativeOk() {
        Preconditions.requireNonNegative((int)0);
        Preconditions.requireNonNegative((int)1);
    }

    @Test
    void requireNonNegativeFailsOnNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requireNonNegative((int)-1));
    }

    @Test
    void checkStateOk() {
        Preconditions.checkState((boolean)true, (String)"must not fail");
    }

    @Test
    void checkStateFails() {
        Assertions.assertThrows(IllegalStateException.class, () -> Preconditions.checkState((boolean)false, (String)"must fail"));
    }

    @Test
    void requirePowerOfTwo() {
        Assertions.assertEquals((long)1L, (long)Preconditions.requirePowerOfTwo((long)1L));
        Assertions.assertEquals((long)2L, (long)Preconditions.requirePowerOfTwo((long)2L));
        Assertions.assertEquals((long)128L, (long)Preconditions.requirePowerOfTwo((long)128L));
        Assertions.assertEquals((long)0x4000000000000000L, (long)Preconditions.requirePowerOfTwo((long)0x4000000000000000L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requirePowerOfTwo((long)-1L), (String)"negative");
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requirePowerOfTwo((long)0L), (String)"zero");
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requirePowerOfTwo((long)3L), (String)"three");
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requirePowerOfTwo((long)Long.MIN_VALUE), (String)"sign bit");
    }

    @Test
    void requireNonEmptyArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requireNonEmpty(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requireNonEmpty((Object[])new String[0]));
        Assertions.assertDoesNotThrow(() -> Preconditions.requireNonEmpty((Object[])new Object[]{1}));
    }

    @Test
    void requireNoNullElementsInArray() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requireNoNullElements((Object[])new Object[]{null}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requireNoNullElements((Object[])new Object[]{null, null}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requireNoNullElements((Object[])new Object[]{1, null}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Preconditions.requireNoNullElements((Object[])new Object[]{null, 1}));
        Assertions.assertDoesNotThrow(() -> Preconditions.requireNoNullElements((Object[])new Object[]{1, 1}));
    }
}

