/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.util.Id;

class IdTest {
    IdTest() {
    }

    @Test
    void idsAreEqualIfSameUuid() {
        UUID uuid = UUID.randomUUID();
        Id id1 = new Id(uuid);
        Id id2 = new Id(uuid);
        Assertions.assertEquals((Object)id1, (Object)id2);
    }

    @Test
    void idsAreNotEqualIfDifferentUuid() {
        Id id1 = new Id(UUID.randomUUID());
        Id id2 = new Id(UUID.randomUUID());
        Assertions.assertNotEquals((Object)id1, (Object)id2);
    }

    @Test
    void shouldPrintShortName() {
        UUID uuid = UUID.randomUUID();
        Id id = new Id(uuid);
        Assertions.assertEquals((Object)uuid.toString().substring(0, 8), (Object)id.toString());
    }

    @Test
    void shouldNotAllowNull() {
        NullPointerException nullPointerException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> new Id(null));
        Assertions.assertEquals((Object)nullPointerException.getMessage(), (Object)"UUID should be not null.");
    }
}

