/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.DefaultTimeoutStrategy;
import org.neo4j.internal.helpers.TimeoutStrategy;

class DefaultTimeoutStrategyTest {
    DefaultTimeoutStrategyTest() {
    }

    @Test
    void shouldFailIfPassedFunctionIsNotIncreasing() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultTimeoutStrategy(0L, 100L, TimeUnit.MILLISECONDS, i -> i - 1L));
    }

    @Test
    void shouldGetAndIncrementCorrectly() {
        DefaultTimeoutStrategy strategy = new DefaultTimeoutStrategy(0L, 100L, TimeUnit.MILLISECONDS, i -> i + 1L);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        Assertions.assertEquals((long)0L, (long)timeout.getAndIncrement());
        Assertions.assertEquals((long)1L, (long)timeout.getAndIncrement());
        Assertions.assertEquals((long)2L, (long)timeout.getMillis());
        TimeoutStrategy.Timeout timeout1 = strategy.newTimeout();
        Assertions.assertEquals((long)0L, (long)timeout1.getMillis());
    }
}

