/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.service.Services;
import org.neo4j.service.test.BarService;
import org.neo4j.service.test.BazService;
import org.neo4j.service.test.FooService;
import org.neo4j.service.test.NotNamedService;
import org.neo4j.service.test.ServiceWithDuplicateName;
import org.neo4j.service.test.SomeService;

class ServicesTest {
    ServicesTest() {
    }

    @Test
    void loadAll() {
        Collection services = Services.loadAll(SomeService.class);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)services).hasSize(2)).hasAtLeastOneElementOfType(FooService.class)).hasAtLeastOneElementOfType(BarService.class);
    }

    @Test
    void loadByName() {
        Optional foo = Services.load(SomeService.class, (String)"foo");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foo.isPresent());
        Assertions.assertThat((Object)((SomeService)foo.get())).isInstanceOf(FooService.class);
        Optional bar = Services.load(SomeService.class, (String)"bar");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)bar.isPresent());
        Assertions.assertThat((Object)((SomeService)bar.get())).isInstanceOf(BarService.class);
    }

    @Test
    void loadByKey() {
        Optional impl1 = Services.load(NotNamedService.class, (Object)1L, NotNamedService::id);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)impl1.isPresent());
        Assertions.assertThat((Object)((NotNamedService)impl1.get())).isInstanceOf(NotNamedService.ServiceImpl1.class);
        Optional impl2 = Services.load(NotNamedService.class, (Object)2L, NotNamedService::id);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)impl2.isPresent());
        Assertions.assertThat((Object)((NotNamedService)impl2.get())).isInstanceOf(NotNamedService.ServiceImpl2.class);
    }

    @Test
    void loadOrFail_load() {
        SomeService service = (SomeService)Services.loadOrFail(SomeService.class, (String)"foo");
        Assertions.assertThat((Object)service).isInstanceOf(FooService.class);
    }

    @Test
    void loadOrFail_fail() {
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchElementException.class, () -> Services.loadOrFail(SomeService.class, (String)"nonexisting-key"));
    }

    @Test
    void loadByNameNoMatch() {
        Optional provider = Services.load(SomeService.class, (String)"nonexisting-key");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)provider.isPresent());
    }

    @Test
    void failOnDuplicateKeyWhenLoadingByName() {
        RuntimeException error = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> Services.load(ServiceWithDuplicateName.class, (String)"duplicate-name"));
        Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"Found multiple service providers"});
    }

    @Test
    void loadByPriority() {
        Optional foo = Services.loadByPriority(SomeService.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foo.isPresent());
        Assertions.assertThat((Object)((SomeService)foo.get())).isInstanceOf(FooService.class);
    }

    @Test
    void loadAllFromCurrentAndContextClassLoadersNoDuplicates() {
        ServicesTest.withContextClassLoader(new TestClassLoader(), () -> {
            Collection services = Services.loadAll(SomeService.class);
            ((IterableAssert)((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)services).hasSize(3)).hasAtLeastOneElementOfType(FooService.class)).hasAtLeastOneElementOfType(BarService.class)).hasAtLeastOneElementOfType(BazService.class);
        });
    }

    @Test
    void loadByNameFromCurrentAndContextClassLoaders() {
        ServicesTest.withContextClassLoader(new TestClassLoader(), () -> {
            Optional foo = Services.load(SomeService.class, (String)"foo");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foo.isPresent());
            Assertions.assertThat((Object)((SomeService)foo.get())).isInstanceOf(FooService.class);
            Optional baz = Services.load(SomeService.class, (String)"baz");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)baz.isPresent());
            Assertions.assertThat((Object)((SomeService)baz.get())).isInstanceOf(BazService.class);
        });
    }

    @Test
    void loadByPriorityFromCurrentAndContextClassLoaders() {
        ServicesTest.withContextClassLoader(new TestClassLoader(), () -> {
            Optional foo = Services.loadByPriority(SomeService.class);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foo.isPresent());
            Assertions.assertThat((Object)((SomeService)foo.get())).isInstanceOf(FooService.class);
        });
    }

    private static void withContextClassLoader(ClassLoader contextClassLoader, Runnable action) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            action.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static final class TestClassLoader
    extends ClassLoader {
        private TestClassLoader() {
        }

        @Override
        public URL getResource(String name) {
            return name.startsWith("META-INF/services") ? super.getResource("test/" + name) : super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return name.startsWith("META-INF/services") ? super.getResources("test/" + name) : super.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return name.startsWith("META-INF/services") ? super.getResourceAsStream("test/" + name) : super.getResourceAsStream(name);
        }
    }
}

