/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;

class LocalMemoryTrackerTest {
    LocalMemoryTrackerTest() {
    }

    @Test
    void trackDirectMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateNative(10L);
        memoryTracker.allocateNative(20L);
        memoryTracker.allocateNative(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)70L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackDirectMemoryDeallocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateNative(100L);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)memoryTracker.usedNativeMemory());
        memoryTracker.releaseNative(20L);
        org.junit.jupiter.api.Assertions.assertEquals((long)80L, (long)memoryTracker.usedNativeMemory());
        memoryTracker.releaseNative(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)40L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackHeapMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateHeap(10L);
        memoryTracker.allocateHeap(20L);
        memoryTracker.allocateHeap(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)70L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void trackHeapMemoryDeallocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        memoryTracker.allocateHeap(100L);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.releaseHeap(20L);
        org.junit.jupiter.api.Assertions.assertEquals((long)80L, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.releaseHeap(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)40L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void throwsOnLimit() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 10L, 0L, "settingName");
        MemoryLimitExceededException memoryLimitExceededException = (MemoryLimitExceededException)org.junit.jupiter.api.Assertions.assertThrows(MemoryLimitExceededException.class, () -> memoryTracker.allocateHeap(100L));
        Assertions.assertThat((String)memoryLimitExceededException.getMessage()).contains(new CharSequence[]{"settingName"});
    }
}

