/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.rule.SuppressOutput;

public class SuppressOutputExtension
extends StatefullFieldExtension<SuppressOutput>
implements BeforeEachCallback,
AfterEachCallback {
    private static final String SUPPRESS_OUTPUT = "suppressOutput";
    private static final ExtensionContext.Namespace SUPPRESS_OUTPUT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"suppressOutput"});

    @Override
    protected String getFieldKey() {
        return SUPPRESS_OUTPUT;
    }

    @Override
    protected Class<SuppressOutput> getFieldType() {
        return SuppressOutput.class;
    }

    @Override
    protected SuppressOutput createField(ExtensionContext extensionContext) {
        return SuppressOutput.suppressAll();
    }

    @Override
    protected ExtensionContext.Namespace getNameSpace() {
        return SUPPRESS_OUTPUT_NAMESPACE;
    }

    public void afterEach(ExtensionContext context) {
        ((SuppressOutput)this.getStoredValue(context)).releaseVoices(context.getExecutionException().isPresent());
        this.removeStoredValue(context);
    }

    public void beforeEach(ExtensionContext context) {
        ((SuppressOutput)this.getStoredValue(context)).captureVoices();
    }
}

