/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.resources.SunManagementHeapAllocation;

class SunManagementHeapAllocationTest {
    SunManagementHeapAllocationTest() {
    }

    @BeforeEach
    void onlyOnSupportedJvms() {
        Assumptions.assumeFalse((HeapAllocation.HEAP_ALLOCATION == HeapAllocation.NOT_AVAILABLE ? 1 : 0) != 0);
    }

    @Test
    void shouldLoadHeapAllocation() {
        Assertions.assertNotSame((Object)HeapAllocation.NOT_AVAILABLE, (Object)HeapAllocation.HEAP_ALLOCATION);
        MatcherAssert.assertThat((Object)HeapAllocation.HEAP_ALLOCATION, (Matcher)Matchers.instanceOf(SunManagementHeapAllocation.class));
    }

    @Test
    void shouldMeasureAllocation() {
        long allocatedBytes = HeapAllocation.HEAP_ALLOCATION.allocatedBytes(Thread.currentThread());
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < 17; ++i) {
            objects.add(new Object());
        }
        MatcherAssert.assertThat((Object)allocatedBytes, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(HeapAllocation.HEAP_ALLOCATION.allocatedBytes(Thread.currentThread()))));
        Assertions.assertEquals((int)17, (int)objects.size());
    }
}

