/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ports.allocation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.neo4j.ports.allocation.CoordinatingPortProvider;
import org.neo4j.ports.allocation.DefaultPortProbe;
import org.neo4j.ports.allocation.PortProvider;
import org.neo4j.ports.allocation.PortRepository;
import org.neo4j.ports.allocation.SimplePortProvider;

public class PortAuthority {
    private static final int PORT_RANGE_MINIMUM = 20000;
    private static final PortProvider portProvider;

    public static int allocatePort() {
        String trace = PortAuthority.buildTrace();
        return portProvider.getNextFreePort(trace);
    }

    private static String buildTrace() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(outputStream);){
            new Exception().printStackTrace(printWriter);
        }
        return new String(outputStream.toByteArray());
    }

    static {
        String portAuthorityDirectory = System.getProperty("port.authority.directory");
        if (portAuthorityDirectory == null) {
            portProvider = new SimplePortProvider(new DefaultPortProbe(), 20000);
        } else {
            try {
                Path directory = Paths.get(portAuthorityDirectory, new String[0]);
                Files.createDirectories(directory, new FileAttribute[0]);
                PortRepository portRepository = new PortRepository(directory, 20000);
                DefaultPortProbe portProbe = new DefaultPortProbe();
                portProvider = new CoordinatingPortProvider(portRepository, portProbe);
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

