/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ports.allocation;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.ports.allocation.CoordinatingPortProvider;
import org.neo4j.ports.allocation.PortProbe;
import org.neo4j.ports.allocation.PortRepository;

class CoordinatingPortProviderTest {
    CoordinatingPortProviderTest() {
    }

    @Test
    void shouldProvideUniquePorts() {
        PortRepository portRepository = (PortRepository)Mockito.mock(PortRepository.class);
        CoordinatingPortProvider portProvider = new CoordinatingPortProvider(portRepository, port -> false);
        Mockito.when((Object)portRepository.reserveNextPort("foo")).thenReturn((Object)40, (Object[])new Integer[]{41});
        int port1 = portProvider.getNextFreePort("foo");
        int port2 = portProvider.getNextFreePort("foo");
        MatcherAssert.assertThat((Object)port1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)port2))));
    }

    @Test
    void shouldSkipReservedPorts() {
        PortRepository portRepository = (PortRepository)Mockito.mock(PortRepository.class);
        CoordinatingPortProvider portProvider = new CoordinatingPortProvider(portRepository, port -> false);
        Mockito.when((Object)portRepository.reserveNextPort("foo")).thenReturn((Object)40, (Object[])new Integer[]{41, 43});
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)40));
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)41));
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)43));
    }

    @Test
    void shouldSkipOccupiedPorts() {
        PortRepository portRepository = (PortRepository)Mockito.mock(PortRepository.class);
        PortProbe portProbe = (PortProbe)Mockito.mock(PortProbe.class);
        CoordinatingPortProvider portProvider = new CoordinatingPortProvider(portRepository, portProbe);
        Mockito.when((Object)portRepository.reserveNextPort("foo")).thenReturn((Object)40, (Object[])new Integer[]{41, 42, 43});
        Mockito.when((Object)portProbe.isOccupied(40)).thenReturn((Object)false);
        Mockito.when((Object)portProbe.isOccupied(41)).thenReturn((Object)false);
        Mockito.when((Object)portProbe.isOccupied(42)).thenReturn((Object)true);
        Mockito.when((Object)portProbe.isOccupied(43)).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)40));
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)41));
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)43));
    }
}

