/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.GlobalMemoryTracker;

class GlobalMemoryTrackerTest {
    GlobalMemoryTrackerTest() {
    }

    @Test
    void trackMemoryAllocations() {
        long initialUsedMemory = GlobalMemoryTracker.INSTANCE.usedDirectMemory();
        GlobalMemoryTracker.INSTANCE.allocated(10L);
        GlobalMemoryTracker.INSTANCE.allocated(20L);
        GlobalMemoryTracker.INSTANCE.allocated(40L);
        Assertions.assertEquals((long)70L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
    }

    @Test
    void trackMemoryDeallocations() {
        long initialUsedMemory = GlobalMemoryTracker.INSTANCE.usedDirectMemory();
        GlobalMemoryTracker.INSTANCE.allocated(100L);
        Assertions.assertEquals((long)100L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
        GlobalMemoryTracker.INSTANCE.deallocated(20L);
        Assertions.assertEquals((long)80L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
        GlobalMemoryTracker.INSTANCE.deallocated(40L);
        Assertions.assertEquals((long)40L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
    }
}

