/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Suppliers;

public class SuppliersTest {
    @Test
    public void singletonSupplierShouldAlwaysReturnSame() {
        Object o = new Object();
        Supplier supplier = Suppliers.singleton((Object)o);
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o));
    }

    @Test
    public void lazySingletonSupplierShouldOnlyRequestInstanceWhenRequired() {
        Object o = new Object();
        Supplier mockSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(mockSupplier.get()).thenReturn(o);
        Supplier supplier = Suppliers.lazySingleton((Supplier)mockSupplier);
        Mockito.verifyZeroInteractions((Object[])new Object[]{mockSupplier});
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o));
        ((Supplier)Mockito.verify((Object)mockSupplier)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockSupplier});
    }

    @Test
    public void adapedSupplierShouldOnlyCallAdaptorOnceForEachNewInstance() {
        Object o1 = new Object();
        Object o1a = new Object();
        Object o2 = new Object();
        Object o2a = new Object();
        Object o3 = new Object();
        Object o3a = new Object();
        Supplier mockSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(mockSupplier.get()).thenReturn(o1, new Object[]{o1, o1, o2, o3, o3});
        Function mockFunction = (Function)Mockito.mock(Function.class);
        Mockito.when(mockFunction.apply(o1)).thenReturn(o1a);
        Mockito.when(mockFunction.apply(o2)).thenReturn(o2a);
        Mockito.when(mockFunction.apply(o3)).thenReturn(o3a);
        Supplier supplier = Suppliers.adapted((Supplier)mockSupplier, (Function)mockFunction);
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o1a));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o1a));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o1a));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o2a));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o3a));
        Assert.assertThat(supplier.get(), (Matcher)Matchers.sameInstance((Object)o3a));
        ((Function)Mockito.verify((Object)mockFunction)).apply(o1);
        ((Function)Mockito.verify((Object)mockFunction)).apply(o2);
        ((Function)Mockito.verify((Object)mockFunction)).apply(o3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockFunction});
    }
}

