/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPoolImpl;

class LocalMemoryTrackerWithPoolTest {
    private static final long LOCAL_LIMIT = 10L;
    private static final long GRAB_SIZE = 2L;
    private MemoryPool memoryPool;
    private LocalMemoryTracker memoryTracker;

    LocalMemoryTrackerWithPoolTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPoolImpl(0L, true, null);
        this.memoryTracker = new LocalMemoryTracker(this.memoryPool, 10L, 2L, null);
    }

    @AfterEach
    void tearDown() {
        this.memoryTracker.reset();
        this.assertReserved(0L);
    }

    @Test
    void trackedNativeAllocationReportedInPool() {
        this.memoryTracker.allocateNative(10L);
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.memoryTracker.usedNativeMemory());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
            org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.memoryPool.usedNative());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryPool.usedHeap());
        }
        finally {
            this.memoryTracker.releaseNative(10L);
        }
    }

    @Test
    void trackedHeapAllocationReportedInPool() {
        this.memoryTracker.allocateHeap(10L);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.memoryTracker.estimatedHeapMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.memoryPool.usedHeap());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryPool.usedNative());
    }

    @Test
    void grabSize() {
        this.memoryTracker.allocateHeap(1L);
        this.assertReserved(2L);
    }

    @Test
    void respectsLocalLimit() {
        org.junit.jupiter.api.Assertions.assertThrows(MemoryLimitExceededException.class, () -> this.memoryTracker.allocateHeap(11L));
    }

    @Test
    void reserveFromParentWhenLocalPoolIsEmpty() {
        this.memoryTracker.allocateHeap(4L);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isGreaterThan(2L);
    }

    @Test
    void negativeAdjustments() {
        this.memoryTracker.allocateHeap(1L);
        this.memoryTracker.releaseHeap(1L);
        this.memoryTracker.allocateHeap(1L);
        this.memoryTracker.releaseHeap(1L);
        this.memoryTracker.allocateHeap(1L);
        this.memoryTracker.releaseHeap(1L);
        this.assertReserved(2L);
    }

    @Test
    void largeAdjustments() {
        this.memoryTracker.allocateHeap(10L);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isGreaterThanOrEqualTo(10L);
    }

    @Test
    void zeroAdjustmentsAllowed() {
        this.memoryTracker.allocateHeap(0L);
    }

    @Test
    void releaseToParentIfLocalPoolMuchLargerThanUsed() {
        this.memoryTracker.allocateHeap(10L);
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(10L);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isEqualTo(10L);
        this.memoryTracker.releaseHeap(8L);
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(2L);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isLessThan(10L);
    }

    private void assertReserved(long i) {
        org.junit.jupiter.api.Assertions.assertEquals((long)i, (long)this.memoryPool.usedHeap());
    }
}

