/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;

class MemoryPoolsTest {
    MemoryPoolsTest() {
    }

    @Test
    void createdPoolRegisteredInListOfPools() {
        MemoryPools pools = new MemoryPools();
        GlobalMemoryGroupTracker pool1 = pools.pool(MemoryGroup.OTHER, 2L, true, null);
        GlobalMemoryGroupTracker pool2 = pools.pool(MemoryGroup.TRANSACTION, 2L, true, null);
        Assertions.assertThat((List)pools.getPools()).contains((Object[])new GlobalMemoryGroupTracker[]{pool1, pool2});
    }

    @Test
    void poolsWithDisabledMemoryTracking() {
        MemoryPools pools = new MemoryPools(false);
        GlobalMemoryGroupTracker pool = pools.pool(MemoryGroup.TRANSACTION, 2L, true, null);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedNative());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedHeap());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.totalUsed());
        MemoryTracker memoryTracker = pool.getPoolMemoryTracker();
        memoryTracker.allocateHeap(100L);
        memoryTracker.allocateNative(1000L);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedNative());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedHeap());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.totalUsed());
    }

    @Test
    void subpoolWithDisabledMemoryTracking() {
        MemoryPools pools = new MemoryPools(false);
        ScopedMemoryPool pool = pools.pool(MemoryGroup.TRANSACTION, 2L, true, null).newDatabasePool("test", 1L, null);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedNative());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedHeap());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.totalUsed());
        MemoryTracker memoryTracker = pool.getPoolMemoryTracker();
        memoryTracker.allocateHeap(100L);
        memoryTracker.allocateNative(1000L);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedNative());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.usedHeap());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pool.totalUsed());
    }

    @Test
    void poolIsDeregisteredOnClose() {
        MemoryPools pools = new MemoryPools();
        GlobalMemoryGroupTracker pool = pools.pool(MemoryGroup.TRANSACTION, 2L, true, null);
        Assertions.assertThat((List)pools.getPools()).contains((Object[])new GlobalMemoryGroupTracker[]{pool});
        pool.close();
        Assertions.assertThat((List)pools.getPools()).isEmpty();
    }

    @Test
    void registerAndDeregisterExternalPool() {
        MemoryPools pools = new MemoryPools();
        Assertions.assertThat((List)pools.getPools()).isEmpty();
        GlobalMemoryGroupTracker externalPool = new GlobalMemoryGroupTracker(pools, MemoryGroup.NO_TRACKING, 0L, true, true, null);
        pools.registerPool(externalPool);
        Assertions.assertThat((List)pools.getPools()).hasSize(1);
        Assertions.assertThat((List)pools.getPools()).contains((Object[])new GlobalMemoryGroupTracker[]{externalPool});
        pools.unregisterPool(externalPool);
        Assertions.assertThat((List)pools.getPools()).isEmpty();
    }
}

