/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.memory.ExecutionContextMemoryTracker;
import org.neo4j.memory.HighWaterMarkMemoryPool;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPoolImpl;

class ExecutionContextMemoryTrackerTest {
    ExecutionContextMemoryTrackerTest() {
    }

    @Test
    void trackDirectMemoryAllocations() {
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker();
        memoryTracker.allocateNative(10L);
        memoryTracker.allocateNative(20L);
        memoryTracker.allocateNative(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)70L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackDirectMemoryDeallocations() {
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker();
        memoryTracker.allocateNative(100L);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)memoryTracker.usedNativeMemory());
        memoryTracker.releaseNative(20L);
        org.junit.jupiter.api.Assertions.assertEquals((long)80L, (long)memoryTracker.usedNativeMemory());
        memoryTracker.releaseNative(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)40L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackHeapMemoryAllocations() {
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker();
        memoryTracker.allocateHeap(10L);
        memoryTracker.allocateHeap(20L);
        memoryTracker.allocateHeap(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)70L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void trackHeapMemoryDeallocations() {
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker();
        memoryTracker.allocateHeap(100L);
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.releaseHeap(20L);
        org.junit.jupiter.api.Assertions.assertEquals((long)80L, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.releaseHeap(40L);
        org.junit.jupiter.api.Assertions.assertEquals((long)40L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void throwsOnLimitHeap() {
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(HighWaterMarkMemoryPool.NO_TRACKING, 10L, 0L, 0L, "settingName");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> memoryTracker.allocateHeap(100L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("settingName");
        Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isEqualTo(0L);
    }

    @Test
    void throwsOnLimitNative() {
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(HighWaterMarkMemoryPool.NO_TRACKING, 10L, 0L, 0L, "settingName");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> memoryTracker.allocateNative(100L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("settingName");
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isEqualTo(0L);
    }

    @Test
    void throwsOnPoolLimitHeap() {
        HighWaterMarkMemoryPool pool = new HighWaterMarkMemoryPool((MemoryPool)new MemoryPoolImpl(5L, true, "poolSetting"));
        ExecutionContextMemoryTracker tracker = new ExecutionContextMemoryTracker(pool, 10L, 0L, 0L, "localSetting");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tracker.allocateHeap(10L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("poolSetting");
        Assertions.assertThat((long)tracker.estimatedHeapMemory()).isEqualTo(0L);
    }

    @Test
    void throwsOnPoolLimitNative() {
        HighWaterMarkMemoryPool pool = new HighWaterMarkMemoryPool((MemoryPool)new MemoryPoolImpl(5L, true, "poolSetting"));
        ExecutionContextMemoryTracker tracker = new ExecutionContextMemoryTracker(pool, 10L, 0L, 0L, "localSetting");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tracker.allocateNative(10L)).isInstanceOf(MemoryLimitExceededException.class)).hasMessageContaining("poolSetting");
        Assertions.assertThat((long)tracker.usedNativeMemory()).isEqualTo(0L);
    }

    @Test
    void shouldIncreaseGrabSizeOnLargerAllocations() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 100;
        long allocationSize = 10L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.allocateHeap(allocationSize);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).reserveHeap(20L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(32L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(64L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)9))).reserveHeap(100L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalAllocationSize = (long)nAllocations * allocationSize;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTotalAllocationSize, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = 1036L - expectedTotalAllocationSize;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldIncreaseGrabSizeOnLargerAllocations2() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 50;
        long allocationSize = 20L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.allocateHeap(allocationSize);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).reserveHeap(20L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(32L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(64L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)9))).reserveHeap(100L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalAllocationSize = (long)nAllocations * allocationSize;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTotalAllocationSize, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = 1036L - expectedTotalAllocationSize;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldIncreaseGrabSizeOnLargerAllocationsWithInitialPowerOfTwo() {
        long grabSize = 16L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 100;
        long allocationSize = 10L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.allocateHeap(allocationSize);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).reserveHeap(16L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(32L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(64L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)9))).reserveHeap(100L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalAllocationSize = (long)nAllocations * allocationSize;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTotalAllocationSize, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.allocateHeap(1L);
        memoryTracker.reset();
        long expectedLocalHeapPool = 1028L - expectedTotalAllocationSize - 1L;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldNotIncreaseGrabSizeOnSmallAllocations() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 100;
        long allocationSize = 2L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.allocateHeap(allocationSize);
        }
        long expectedTotalAllocationSize = (long)nAllocations * allocationSize;
        int expectedNumberOfGrabs = (int)(expectedTotalAllocationSize / grabSize);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)expectedNumberOfGrabs))).reserveHeap(grabSize);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTotalAllocationSize, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = (long)expectedNumberOfGrabs * grabSize - expectedTotalAllocationSize;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.never())).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldIncreasePoolReleaseSizeOnLargerReleases() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 100;
        long allocationSize = 10L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.releaseHeap(allocationSize);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).releaseHeap(20L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(32L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).releaseHeap(64L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)6))).releaseHeap(100L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalReleaseSize = (long)nAllocations * allocationSize;
        org.junit.jupiter.api.Assertions.assertEquals((long)(-expectedTotalReleaseSize), (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.allocateHeap(1L);
        memoryTracker.reset();
        long expectedLocalHeapPool = expectedTotalReleaseSize - 800L - 1L;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldIncreasePoolReleaseSizeOnLargerReleases2() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 50;
        long allocationSize = 20L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.releaseHeap(allocationSize);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).releaseHeap(20L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(32L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(64L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)7))).releaseHeap(100L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalReleaseSize = (long)nAllocations * allocationSize;
        org.junit.jupiter.api.Assertions.assertEquals((long)(-expectedTotalReleaseSize), (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = expectedTotalReleaseSize - 836L;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldIncreasePoolReleaseSizeOnLargerReleasesWithInitialPowerOfTwo() {
        long grabSize = 16L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 100;
        long allocationSize = 10L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.releaseHeap(allocationSize);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).releaseHeap(16L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(32L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)2))).releaseHeap(64L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)7))).releaseHeap(100L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalReleaseSize = (long)nAllocations * allocationSize;
        org.junit.jupiter.api.Assertions.assertEquals((long)(-expectedTotalReleaseSize), (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = expectedTotalReleaseSize - 892L;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldNotIncreasePoolReleaseSizeOnSmallReleases() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        int nAllocations = 100;
        long allocationSize = 2L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.releaseHeap(allocationSize);
        }
        long expectedTotalReleaseSize = (long)nAllocations * allocationSize;
        int expectedNumberOfPoolReleases = (int)(expectedTotalReleaseSize / grabSize) - 2;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)expectedNumberOfPoolReleases))).releaseHeap(grabSize);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        org.junit.jupiter.api.Assertions.assertEquals((long)(-expectedTotalReleaseSize), (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.allocateHeap(1L);
        memoryTracker.reset();
        long expectedLocalHeapPool = expectedTotalReleaseSize - (long)expectedNumberOfPoolReleases * grabSize - 1L;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void initialCreditShouldPreventGrab() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        long initialCredit = 20L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        memoryTracker.releaseHeap(initialCredit);
        int nAllocations = 3;
        long allocationSize = 10L;
        for (int i = 0; i < nAllocations; ++i) {
            memoryTracker.allocateHeap(allocationSize);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(grabSize);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalAllocationSize = (long)nAllocations * allocationSize - initialCredit;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTotalAllocationSize, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = expectedTotalAllocationSize;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void shouldHandleBalancedCallsWithLocalHeapPool() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        long initialCredit = 20L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        memoryTracker.releaseHeap(initialCredit);
        memoryTracker.allocateHeap(20L);
        memoryTracker.releaseHeap(20L);
        memoryTracker.releaseHeap(20L);
        memoryTracker.allocateHeap(20L);
        memoryTracker.allocateHeap(20L);
        memoryTracker.releaseHeap(20L);
        memoryTracker.allocateHeap(20L);
        Mockito.verifyNoInteractions((Object[])new Object[]{pool});
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
    }

    @Test
    void oneOffLargeAllocationDoesNotImmediatelyAffectGrabSize() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        memoryTracker.allocateHeap(1000L);
        memoryTracker.allocateHeap(10L);
        memoryTracker.allocateHeap(10L);
        memoryTracker.allocateHeap(10L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(1000L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(20L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(32L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalAllocationSize = 1030L;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTotalAllocationSize, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = 1052L - expectedTotalAllocationSize;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void oneOffLargeReleaseDoesNotImmediatelyAffectGrabSize() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        memoryTracker.releaseHeap(1000L);
        int nSmallAllocations = 8;
        for (int i = 0; i < nSmallAllocations; ++i) {
            memoryTracker.allocateHeap(10L);
        }
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(1000L - grabSize * 2L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(20L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).reserveHeap(32L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        long expectedTotalAllocationSize = (long)nSmallAllocations * 10L - 1000L;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedTotalAllocationSize, (long)memoryTracker.estimatedHeapMemory());
        memoryTracker.reset();
        long expectedLocalHeapPool = 12L;
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)1))).releaseHeap(expectedLocalHeapPool);
    }

    @Test
    void usedUpInitialCreditShouldBeReservedOnResetIfThereWereNoGrabs() {
        long grabSize = 20L;
        long maxGrabSize = 100L;
        long initialCredit = 20L;
        HighWaterMarkMemoryPool pool = (HighWaterMarkMemoryPool)Mockito.mock(HighWaterMarkMemoryPool.class);
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, grabSize, maxGrabSize, "settingName");
        memoryTracker.releaseHeap(initialCredit);
        memoryTracker.allocateHeap(10L);
        ((HighWaterMarkMemoryPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.never())).reserveHeap(grabSize);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pool});
        memoryTracker.reset();
    }

    @Test
    void trackHeapHighWaterMark() {
        HighWaterMarkMemoryPool pool = new HighWaterMarkMemoryPool((MemoryPool)new MemoryPoolImpl(1000L, true, "poolSetting"));
        int grabSize = 100;
        ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, (long)grabSize, (long)grabSize, "poolSetting");
        memoryTracker.allocateHeap(10L);
        org.junit.jupiter.api.Assertions.assertEquals((long)grabSize, (long)memoryTracker.heapHighWaterMark());
        memoryTracker.allocateHeap(89L);
        org.junit.jupiter.api.Assertions.assertEquals((long)grabSize, (long)memoryTracker.heapHighWaterMark());
        memoryTracker.allocateHeap(10L);
        org.junit.jupiter.api.Assertions.assertEquals((long)(2 * grabSize), (long)memoryTracker.heapHighWaterMark());
    }

    @Test
    void trackHeapHighWaterMarkConcurrent() throws InterruptedException {
        MemoryPoolImpl poolSetting = new MemoryPoolImpl(1000L, true, "poolSetting");
        HighWaterMarkMemoryPool pool = new HighWaterMarkMemoryPool((MemoryPool)poolSetting);
        int grabSize = 100;
        int nThreads = 10;
        ExecutorService service = Executors.newFixedThreadPool(10);
        for (int i = 0; i < nThreads; ++i) {
            service.submit(() -> {
                try (ExecutionContextMemoryTracker memoryTracker = new ExecutionContextMemoryTracker(pool, 0L, (long)grabSize, (long)grabSize, "poolSetting");){
                    memoryTracker.allocateHeap(11L);
                }
            });
        }
        service.shutdown();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES));
        Assertions.assertThat((long)pool.heapHighWaterMark()).isLessThanOrEqualTo((long)(nThreads * grabSize));
    }
}

