/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;

class DatabaseMemoryGroupTrackerTest {
    private final MemoryPools memoryPools = new MemoryPools();
    private final GlobalMemoryGroupTracker globalPool = this.memoryPools.pool(MemoryGroup.TRANSACTION, 100L, null);

    DatabaseMemoryGroupTrackerTest() {
    }

    @AfterEach
    void tearDown() {
        Assertions.assertEquals((long)0L, (long)this.globalPool.totalUsed());
        this.globalPool.close();
    }

    private static Stream<Arguments> arguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{new AllocationFacade("heap", MemoryPool::usedHeap, MemoryPool::reserveHeap, MemoryPool::releaseHeap, pool -> pool.getPoolMemoryTracker().estimatedHeapMemory())}), Arguments.of((Object[])new Object[]{new AllocationFacade("native", MemoryPool::usedNative, MemoryPool::reserveNative, MemoryPool::releaseNative, pool -> pool.getPoolMemoryTracker().usedNativeMemory())}));
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void allocateOnParent(AllocationFacade methods) {
        ScopedMemoryPool subPool = this.globalPool.newDatabasePool("pool1", 10L, null);
        methods.reserve(subPool, 2L);
        Assertions.assertEquals((long)2L, (long)methods.used(subPool));
        Assertions.assertEquals((long)2L, (long)methods.used((ScopedMemoryPool)this.globalPool));
        methods.release(subPool, 2L);
        subPool.close();
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void ownPoolFromTracking(AllocationFacade methods) {
        methods.reserve((ScopedMemoryPool)this.globalPool, 2L);
        ScopedMemoryPool subPool = this.globalPool.newDatabasePool("pool1", 10L, null);
        methods.reserve(subPool, 2L);
        Assertions.assertEquals((long)2L, (long)methods.used(subPool));
        Assertions.assertEquals((long)4L, (long)methods.used((ScopedMemoryPool)this.globalPool));
        methods.release(subPool, 2L);
        subPool.close();
        methods.release((ScopedMemoryPool)this.globalPool, 2L);
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void trackMemoryWithDefaultTracker(AllocationFacade methods) {
        ScopedMemoryPool subPool = this.globalPool.newDatabasePool("pool1", 12L, null);
        methods.reserve(subPool, 3L);
        Assertions.assertEquals((long)3L, (long)methods.used(subPool));
        Assertions.assertEquals((long)3L, (long)methods.trackedMemory(subPool));
        methods.release(subPool, 3L);
        Assertions.assertEquals((long)0L, (long)methods.trackedMemory(subPool));
        subPool.close();
    }

    @Test
    void trackedHeapFromPoolAndTrackerMatch() {
        ScopedMemoryPool subPool = this.globalPool.newDatabasePool("pool1", 120L, null);
        MemoryTracker memoryTracker = subPool.getPoolMemoryTracker();
        memoryTracker.allocateHeap(12L);
        Assertions.assertEquals((long)12L, (long)subPool.usedHeap());
        Assertions.assertEquals((long)12L, (long)memoryTracker.estimatedHeapMemory());
        subPool.close();
    }

    @Test
    void trackedNativeFromPoolAndTrackerMatch() {
        ScopedMemoryPool subPool = this.globalPool.newDatabasePool("pool1", 120L, null);
        MemoryTracker memoryTracker = subPool.getPoolMemoryTracker();
        memoryTracker.allocateNative(13L);
        Assertions.assertEquals((long)13L, (long)subPool.usedNative());
        Assertions.assertEquals((long)13L, (long)memoryTracker.usedNativeMemory());
        subPool.close();
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void respectLocalLimit(AllocationFacade methods) {
        ScopedMemoryPool subPool = this.globalPool.newDatabasePool("pool1", 10L, null);
        Assertions.assertThrows(MemoryLimitExceededException.class, () -> methods.reserve(subPool, 11L));
        subPool.close();
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    void respectParentLimit(AllocationFacade methods) {
        ScopedMemoryPool subPool = this.globalPool.newDatabasePool("pool1", 102L, null);
        Assertions.assertThrows(MemoryLimitExceededException.class, () -> methods.reserve(subPool, 101L));
        subPool.close();
    }

    private static final class AllocationFacade {
        final String name;
        final Function<ScopedMemoryPool, Long> used;
        final BiConsumer<ScopedMemoryPool, Long> reserve;
        final BiConsumer<ScopedMemoryPool, Long> release;
        private final ToLongFunction<ScopedMemoryPool> trackedMemory;

        private AllocationFacade(String name, Function<ScopedMemoryPool, Long> used, BiConsumer<ScopedMemoryPool, Long> reserve, BiConsumer<ScopedMemoryPool, Long> release, ToLongFunction<ScopedMemoryPool> trackedMemory) {
            this.name = name;
            this.used = used;
            this.reserve = reserve;
            this.release = release;
            this.trackedMemory = trackedMemory;
        }

        long used(ScopedMemoryPool pool) {
            return this.used.apply(pool);
        }

        void reserve(ScopedMemoryPool pool, long bytes) {
            this.reserve.accept(pool, bytes);
        }

        long trackedMemory(ScopedMemoryPool pool) {
            return this.trackedMemory.applyAsLong(pool);
        }

        void release(ScopedMemoryPool pool, long bytes) {
            this.release.accept(pool, bytes);
        }

        public String toString() {
            return this.name;
        }
    }
}

