/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.DefaultReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.api.exceptions.WriteOnReadOnlyAccessDbException;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;

class DatabaseReadOnlyCheckerTest {
    DatabaseReadOnlyCheckerTest() {
    }

    @Test
    void readOnlyCheckerThrowsExceptionOnCheck() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> DatabaseReadOnlyChecker.readOnly().check());
        Assertions.assertThat((Throwable)e).hasCauseInstanceOf(WriteOnReadOnlyAccessDbException.class);
        WriteOnReadOnlyAccessDbException cause = (WriteOnReadOnlyAccessDbException)e.getCause();
        Assertions.assertThat((String)cause.gqlStatus()).isEqualTo("42N18");
        Assertions.assertThat((String)cause.statusDescription()).isEqualTo("error: syntax error or access rule violation - read-only database. The database is in read-only mode.");
        Assertions.assertThat((String)cause.getMessage()).isEqualTo("This Neo4j server is read-only for all databases");
        Assertions.assertThat((Throwable)cause.getCause()).isNull();
    }

    @Test
    void writeOnlyDoesNotThrowExceptionOnCheck() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> DatabaseReadOnlyChecker.writable().check());
    }

    @Test
    void databaseCheckersShouldReflectUpdatesToGlobalChecker() {
        NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
        HashSet<DatabaseId> databases = new HashSet<DatabaseId>();
        databases.add(foo.databaseId());
        DefaultReadOnlyDatabases globalChecker = new DefaultReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{() -> this.createConfigBasedLookup(databases)});
        DatabaseReadOnlyChecker fooChecker = globalChecker.forDatabase(foo);
        DatabaseReadOnlyChecker barChecker = globalChecker.forDatabase(bar);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)barChecker.isReadOnly());
        databases.add(bar.databaseId());
        globalChecker.refresh();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)barChecker.isReadOnly());
    }

    @Test
    void databaseCheckerShouldCacheLookupsFromGlobalChecker() {
        NamedDatabaseId foo = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        NamedDatabaseId bar = DatabaseIdFactory.from((String)"bar", (UUID)UUID.randomUUID());
        HashSet<DatabaseId> databases = new HashSet<DatabaseId>();
        databases.add(foo.databaseId());
        DefaultReadOnlyDatabases globalChecker = (DefaultReadOnlyDatabases)Mockito.spy((Object)new DefaultReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{() -> this.createConfigBasedLookup(databases)}));
        DatabaseReadOnlyChecker fooChecker = globalChecker.forDatabase(foo);
        DatabaseReadOnlyChecker barChecker = globalChecker.forDatabase(bar);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        ((DefaultReadOnlyDatabases)Mockito.verify((Object)globalChecker, (VerificationMode)Mockito.atMostOnce())).isReadOnly(foo.databaseId());
        databases.add(bar.databaseId());
        globalChecker.refresh();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)barChecker.isReadOnly());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fooChecker.isReadOnly());
        ((DefaultReadOnlyDatabases)Mockito.verify((Object)globalChecker, (VerificationMode)Mockito.times((int)2))).isReadOnly(foo.databaseId());
    }

    private ReadOnlyDatabases.Lookup createConfigBasedLookup(final Set<DatabaseId> databaseIds) {
        return new ReadOnlyDatabases.Lookup(){

            public boolean databaseIsReadOnly(DatabaseId databaseId) {
                return databaseIds.contains(databaseId);
            }

            public ReadOnlyDatabases.Lookup.Source source() {
                return ReadOnlyDatabases.Lookup.Source.CONFIG;
            }
        };
    }
}

