/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ServerFailureException;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;

public class StoreCopyServer {
    private final NeoStoreDataSource dataSource;
    private final CheckPointer checkPointer;
    private final FileSystemAbstraction fileSystem;
    private final File storeDirectory;
    private final Monitor monitor;

    public StoreCopyServer(NeoStoreDataSource dataSource, CheckPointer checkPointer, FileSystemAbstraction fileSystem, File storeDirectory, Monitor monitor) {
        this.dataSource = dataSource;
        this.checkPointer = checkPointer;
        this.fileSystem = fileSystem;
        this.storeDirectory = FileUtils.getMostCanonicalFile((File)storeDirectory);
        this.monitor = monitor;
    }

    public Monitor monitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestContext flushStoresAndStreamStoreFiles(StoreWriter writer, boolean includeLogs) {
        try {
            this.monitor.startTryCheckPoint();
            long lastAppliedTransaction = this.checkPointer.tryCheckPoint((TriggerInfo)new SimpleTriggerInfo("store copy"));
            this.monitor.finishTryCheckPoint();
            ByteBuffer temporaryBuffer = ByteBuffer.allocateDirect((int)ByteUnit.mebiBytes((long)1L));
            this.monitor.startStreamingStoreFiles();
            try (ResourceIterator files = this.dataSource.listStoreFiles(includeLogs);){
                while (files.hasNext()) {
                    StoreChannel fileChannel;
                    block27: {
                        File file = (File)files.next();
                        fileChannel = this.fileSystem.open(file, "r");
                        Throwable throwable = null;
                        try {
                            this.monitor.startStreamingStoreFile(file);
                            writer.write(FileUtils.relativePath((File)this.storeDirectory, (File)file), (ReadableByteChannel)fileChannel, temporaryBuffer, file.length() > 0L);
                            this.monitor.finishStreamingStoreFile(file);
                            if (fileChannel == null) continue;
                            if (throwable == null) break block27;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (fileChannel == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        fileChannel.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                fileChannel.close();
                                throw throwable3;
                            }
                        }
                        try {
                            fileChannel.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    fileChannel.close();
                }
                return RequestContext.anonymous(lastAppliedTransaction);
            }
            finally {
                this.monitor.finishStreamingStoreFiles();
            }
        }
        catch (IOException e) {
            throw new ServerFailureException(e);
        }
    }

    public static interface Monitor {
        public void startTryCheckPoint();

        public void finishTryCheckPoint();

        public void startStreamingStoreFile(File var1);

        public void finishStreamingStoreFile(File var1);

        public void startStreamingStoreFiles();

        public void finishStreamingStoreFiles();

        public void startStreamingTransactions(long var1);

        public void finishStreamingTransactions(long var1);

        public static class Adapter
        implements Monitor {
            @Override
            public void startTryCheckPoint() {
            }

            @Override
            public void finishTryCheckPoint() {
            }

            @Override
            public void startStreamingStoreFile(File file) {
            }

            @Override
            public void finishStreamingStoreFile(File file) {
            }

            @Override
            public void startStreamingStoreFiles() {
            }

            @Override
            public void finishStreamingStoreFiles() {
            }

            @Override
            public void startStreamingTransactions(long startTxId) {
            }

            @Override
            public void finishStreamingTransactions(long endTxId) {
            }
        }
    }
}

