/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.neo4j.com.ChannelCloser;
import org.neo4j.com.RequestContext;
import org.neo4j.helpers.Clock;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class IdleChannelReaper
implements Runnable {
    private final Map<Channel, Request> connectedChannels = new HashMap<Channel, Request>();
    private Clock clock;
    private final Log msgLog;
    private ChannelCloser channelCloser;
    private long thresholdMillis;

    public IdleChannelReaper(ChannelCloser channelCloser, LogProvider logProvider, Clock clock, long thresholdMillis) {
        this.channelCloser = channelCloser;
        this.clock = clock;
        this.thresholdMillis = thresholdMillis;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    public synchronized void add(Channel channel, RequestContext requestContext) {
        Request previous = this.connectedChannels.get(channel);
        if (previous != null) {
            previous.lastTimeHeardOf = this.clock.currentTimeMillis();
        } else {
            this.connectedChannels.put(channel, new Request(requestContext, this.clock.currentTimeMillis()));
        }
    }

    public synchronized Request remove(Channel channel) {
        return this.connectedChannels.remove(channel);
    }

    public synchronized boolean update(Channel channel) {
        Request request = this.connectedChannels.get(channel);
        if (request == null) {
            return false;
        }
        request.lastTimeHeardOf = this.clock.currentTimeMillis();
        return true;
    }

    @Override
    public synchronized void run() {
        for (Map.Entry<Channel, Request> entry : this.connectedChannels.entrySet()) {
            Channel channel = entry.getKey();
            long age = this.clock.currentTimeMillis() - entry.getValue().lastTimeHeardOf;
            if (age > this.thresholdMillis) {
                this.msgLog.info("Found a silent channel " + entry + ", " + age);
                this.channelCloser.tryToCloseChannel(channel);
                continue;
            }
            if (age <= this.thresholdMillis / 2L || channel.isOpen() && channel.isConnected() && channel.isBound()) continue;
            this.channelCloser.tryToCloseChannel(channel);
        }
    }

    public static class Request {
        private final RequestContext requestContext;
        private long lastTimeHeardOf;

        public Request(RequestContext requestContext, long lastTimeHeardOf) {
            this.requestContext = requestContext;
            this.lastTimeHeardOf = lastTimeHeardOf;
        }

        public RequestContext getRequestContext() {
            return this.requestContext;
        }
    }
}

