/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.PrefetchingIterator;

public abstract class TransactionStream
extends PrefetchingIterator<Triplet<String, Long, TxExtractor>> {
    public static final TransactionStream EMPTY = new TransactionStream(new String[0]){

        protected Triplet<String, Long, TxExtractor> fetchNextOrNull() {
            return null;
        }
    };
    private final String[] datasources;

    public TransactionStream(String ... datasources) {
        this.datasources = datasources;
    }

    public String[] dataSourceNames() {
        return (String[])this.datasources.clone();
    }

    public static TransactionStream create(Collection<String> datasources, Iterable<Triplet<String, Long, TxExtractor>> streamSource) {
        final Iterator<Triplet<String, Long, TxExtractor>> stream = streamSource.iterator();
        return new TransactionStream(datasources.toArray(new String[datasources.size()])){

            protected Triplet<String, Long, TxExtractor> fetchNextOrNull() {
                if (stream.hasNext()) {
                    return (Triplet)stream.next();
                }
                return null;
            }
        };
    }

    public void close() {
    }
}

