/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.com.StoreWriter;

public class ToFileStoreWriter
implements StoreWriter {
    private final File basePath;

    public ToFileStoreWriter(File graphDbStoreDir) {
        this.basePath = graphDbStoreDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        int n;
        block8: {
            temporaryBuffer.clear();
            File file = new File(this.basePath, path);
            RandomAccessFile randomAccessFile = null;
            try {
                file.getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(file, "rw");
                int totalWritten = 0;
                if (hasData) {
                    FileChannel channel = randomAccessFile.getChannel();
                    while (data.read(temporaryBuffer) >= 0) {
                        temporaryBuffer.flip();
                        totalWritten += temporaryBuffer.limit();
                        channel.write(temporaryBuffer);
                        temporaryBuffer.clear();
                    }
                }
                n = totalWritten;
                if (randomAccessFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
            }
            randomAccessFile.close();
        }
        return n;
    }

    @Override
    public void done() {
    }
}

