/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.util.Arrays;

public final class RequestContext {
    private final int machineId;
    private final Tx[] lastAppliedTransactions;
    private final int eventIdentifier;
    private final int hashCode;
    private final long epoch;
    private final int masterId;
    private final long checksum;
    public static final RequestContext EMPTY = new RequestContext(-1L, -1, -1, new Tx[0], -1, -1L);

    public static Tx lastAppliedTx(String dataSourceName, long txId) {
        return new Tx(dataSourceName, txId);
    }

    public RequestContext(long epoch, int machineId, int eventIdentifier, Tx[] lastAppliedTransactions, int masterId, long checksum) {
        this.epoch = epoch;
        this.machineId = machineId;
        this.eventIdentifier = eventIdentifier;
        this.lastAppliedTransactions = lastAppliedTransactions;
        this.masterId = masterId;
        this.checksum = checksum;
        long hash = epoch;
        hash = 31L * hash ^ (long)eventIdentifier;
        hash = 31L * hash ^ (long)machineId;
        this.hashCode = (int)(hash >>> 32 ^ hash);
    }

    public int machineId() {
        return this.machineId;
    }

    public Tx[] lastAppliedTransactions() {
        return this.lastAppliedTransactions;
    }

    public int getEventIdentifier() {
        return this.eventIdentifier;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public int getMasterId() {
        return this.masterId;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String toString() {
        return "RequestContext[session: " + this.epoch + ", ID:" + this.machineId + ", eventIdentifier:" + this.eventIdentifier + ", " + Arrays.asList(this.lastAppliedTransactions) + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestContext)) {
            return false;
        }
        RequestContext o = (RequestContext)obj;
        return o.eventIdentifier == this.eventIdentifier && o.machineId == this.machineId && o.epoch == this.epoch;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static RequestContext anonymous(Tx[] lastAppliedTransactions) {
        return new RequestContext(RequestContext.EMPTY.epoch, RequestContext.EMPTY.machineId, RequestContext.EMPTY.eventIdentifier, lastAppliedTransactions, RequestContext.EMPTY.masterId, RequestContext.EMPTY.checksum);
    }

    public static class Tx {
        private final String dataSourceName;
        private final long txId;

        public Tx(String dataSourceName, long txId) {
            this.dataSourceName = dataSourceName;
            this.txId = txId;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public long getTxId() {
            return this.txId;
        }

        public String toString() {
            return this.dataSourceName + "/" + this.txId;
        }
    }
}

