/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.queue.BlockingReadHandler;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.ChunkingChannelBuffer;
import org.neo4j.com.ComException;
import org.neo4j.com.DechunkingChannelBuffer;
import org.neo4j.com.Deserializer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public class Protocol {
    public static final int MEGA = 0x100000;
    public static final int DEFAULT_FRAME_LENGTH = 0x1000000;
    private final int chunkSize;
    private final byte applicationProtocolVersion;
    private final byte internalProtocolVersion;
    public static final ObjectSerializer<Integer> INTEGER_SERIALIZER = new ObjectSerializer<Integer>(){

        @Override
        public void write(Integer responseObject, ChannelBuffer result) throws IOException {
            result.writeInt(responseObject.intValue());
        }
    };
    public static final ObjectSerializer<Long> LONG_SERIALIZER = new ObjectSerializer<Long>(){

        @Override
        public void write(Long responseObject, ChannelBuffer result) throws IOException {
            result.writeLong(responseObject.longValue());
        }
    };
    public static final ObjectSerializer<Void> VOID_SERIALIZER = new ObjectSerializer<Void>(){

        @Override
        public void write(Void responseObject, ChannelBuffer result) throws IOException {
        }
    };
    public static final Deserializer<Integer> INTEGER_DESERIALIZER = new Deserializer<Integer>(){

        @Override
        public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            return buffer.readInt();
        }
    };
    public static final Deserializer<Void> VOID_DESERIALIZER = new Deserializer<Void>(){

        @Override
        public Void read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            return null;
        }
    };
    public static final Serializer EMPTY_SERIALIZER = new Serializer(){

        @Override
        public void write(ChannelBuffer buffer) throws IOException {
        }
    };

    public Protocol(int chunkSize, byte applicationProtocolVersion, byte internalProtocolVersion) {
        this.chunkSize = chunkSize;
        this.applicationProtocolVersion = applicationProtocolVersion;
        this.internalProtocolVersion = internalProtocolVersion;
    }

    public void serializeRequest(Channel channel, ChannelBuffer buffer, RequestType<?> type, RequestContext ctx, Serializer payload) throws IOException {
        buffer.clear();
        ChunkingChannelBuffer chunkingBuffer = new ChunkingChannelBuffer(buffer, channel, this.chunkSize, this.internalProtocolVersion, this.applicationProtocolVersion);
        chunkingBuffer.writeByte(type.id());
        this.writeContext(ctx, chunkingBuffer);
        payload.write(chunkingBuffer);
        chunkingBuffer.done();
    }

    public <PAYLOAD> Response<PAYLOAD> deserializeResponse(BlockingReadHandler<ChannelBuffer> reader, ByteBuffer input, long timeout, Deserializer<PAYLOAD> payloadDeserializer, ResourceReleaser channelReleaser) throws IOException {
        DechunkingChannelBuffer dechunkingBuffer = new DechunkingChannelBuffer(reader, timeout, this.internalProtocolVersion, this.applicationProtocolVersion);
        PAYLOAD response = payloadDeserializer.read(dechunkingBuffer, input);
        StoreId storeId = this.readStoreId(dechunkingBuffer, input);
        TransactionStream txStreams = this.readTransactionStreams(dechunkingBuffer);
        return new Response<PAYLOAD>(response, storeId, txStreams, channelReleaser);
    }

    private void writeContext(RequestContext context, ChannelBuffer targetBuffer) {
        targetBuffer.writeLong(context.getEpoch());
        targetBuffer.writeInt(context.machineId());
        targetBuffer.writeInt(context.getEventIdentifier());
        RequestContext.Tx[] txs = context.lastAppliedTransactions();
        targetBuffer.writeByte(txs.length);
        for (RequestContext.Tx tx : txs) {
            Protocol.writeString(targetBuffer, tx.getDataSourceName());
            targetBuffer.writeLong(tx.getTxId());
        }
        targetBuffer.writeInt(context.getMasterId());
        targetBuffer.writeLong(context.getChecksum());
    }

    private TransactionStream readTransactionStreams(final ChannelBuffer buffer) {
        final String[] datasources = this.readTransactionStreamHeader(buffer);
        if (datasources.length == 1) {
            return TransactionStream.EMPTY;
        }
        return new TransactionStream(new String[0]){

            protected Triplet<String, Long, TxExtractor> fetchNextOrNull() {
                Protocol.makeSureNextTransactionIsFullyFetched(buffer);
                String datasource = datasources[buffer.readUnsignedByte()];
                if (datasource == null) {
                    return null;
                }
                long txId = buffer.readLong();
                TxExtractor extractor = TxExtractor.create(new BlockLogReader(buffer));
                return Triplet.of((Object)datasource, (Object)txId, (Object)extractor);
            }

            @Override
            public String[] dataSourceNames() {
                return Arrays.copyOfRange(datasources, 1, datasources.length);
            }
        };
    }

    private String[] readTransactionStreamHeader(ChannelBuffer buffer) {
        short numberOfDataSources = buffer.readUnsignedByte();
        String[] datasources = new String[numberOfDataSources + 1];
        datasources[0] = null;
        for (int i = 1; i < datasources.length; ++i) {
            datasources[i] = Protocol.readString(buffer);
        }
        return datasources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeSureNextTransactionIsFullyFetched(ChannelBuffer buffer) {
        buffer.markReaderIndex();
        try {
            if (buffer.readUnsignedByte() > 0) {
                buffer.skipBytes(8);
                short blockSize = 0;
                while ((blockSize = buffer.readUnsignedByte()) == 0) {
                    buffer.skipBytes(255);
                }
                buffer.skipBytes((int)blockSize);
            }
        }
        finally {
            buffer.resetReaderIndex();
        }
    }

    private StoreId readStoreId(ChannelBuffer source, ByteBuffer byteBuffer) {
        byteBuffer.clear();
        byteBuffer.limit(24);
        source.readBytes(byteBuffer);
        byteBuffer.flip();
        return StoreId.deserialize((ByteBuffer)byteBuffer);
    }

    public static void addLengthFieldPipes(ChannelPipeline pipeline, int frameLength) {
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(frameLength + 4, 0, 4, 0, 4));
        pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
    }

    public static void writeString(ChannelBuffer buffer, String name) {
        char[] chars = name.toCharArray();
        buffer.writeInt(chars.length);
        Protocol.writeChars(buffer, chars);
    }

    public static void writeChars(ChannelBuffer buffer, char[] chars) {
        for (char ch : chars) {
            buffer.writeChar((int)ch);
        }
    }

    public static String readString(ChannelBuffer buffer) {
        return Protocol.readString(buffer, buffer.readInt());
    }

    public static boolean readBoolean(ChannelBuffer buffer) {
        byte value = buffer.readByte();
        switch (value) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new ComException("Invalid boolean value " + value);
    }

    public static String readString(ChannelBuffer buffer, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = buffer.readChar();
        }
        return new String(chars);
    }

    public static void assertChunkSizeIsWithinFrameSize(int chunkSize, int frameLength) {
        if (chunkSize > frameLength) {
            throw new IllegalArgumentException("Chunk size " + chunkSize + " needs to be equal or less than frame length " + frameLength);
        }
    }

    public static class FileStreamsDeserializer
    implements Deserializer<Void> {
        private final StoreWriter writer;

        public FileStreamsDeserializer(StoreWriter writer) {
            this.writer = writer;
        }

        @Override
        public Void read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            int pathLength;
            while (0 != (pathLength = buffer.readUnsignedShort())) {
                String path = Protocol.readString(buffer, pathLength);
                boolean hasData = buffer.readByte() == 1;
                this.writer.write(path, hasData ? new BlockLogReader(buffer) : null, temporaryBuffer, hasData);
            }
            this.writer.done();
            return null;
        }
    }
}

