/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.queue.BlockingReadHandler;
import org.neo4j.com.ComException;
import org.neo4j.com.Deserializer;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.com.LoggingResourcePoolMonitor;
import org.neo4j.com.MismatchingVersionHandler;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourcePool;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.nioneo.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public abstract class Client<T>
extends LifecycleAdapter
implements ChannelPipelineFactory {
    public static final int DEFAULT_MAX_NUMBER_OF_CONCURRENT_CHANNELS_PER_CLIENT = 20;
    public static final int DEFAULT_READ_RESPONSE_TIMEOUT_SECONDS = 20;
    private ClientBootstrap bootstrap;
    private final SocketAddress address;
    private final StringLogger msgLog;
    private ExecutorService executor;
    private ResourcePool<Triplet<Channel, ChannelBuffer, ByteBuffer>> channelPool;
    private final Protocol protocol;
    private final int frameLength;
    private final long readTimeout;
    private final int maxUnusedChannels;
    private final StoreId storeId;
    private ResourceReleaser resourcePoolReleaser;
    private final List<MismatchingVersionHandler> mismatchingVersionHandlers;
    private final RequestMonitor requestMonitor;
    private int chunkSize;

    public Client(String hostNameOrIp, int port, Logging logging, Monitors monitors, StoreId storeId, int frameLength, byte applicationProtocolVersion, long readTimeout, int maxConcurrentChannels, int chunkSize) {
        Protocol.assertChunkSizeIsWithinFrameSize(chunkSize, frameLength);
        this.msgLog = logging.getMessagesLog(((Object)((Object)this)).getClass());
        this.storeId = storeId;
        this.frameLength = frameLength;
        this.readTimeout = readTimeout;
        this.maxUnusedChannels = maxConcurrentChannels;
        this.mismatchingVersionHandlers = new ArrayList<MismatchingVersionHandler>(2);
        this.address = new InetSocketAddress(hostNameOrIp, port);
        this.protocol = new Protocol(chunkSize, applicationProtocolVersion, this.getInternalProtocolVersion());
        this.msgLog.info(((Object)((Object)this)).getClass().getSimpleName() + " communication channel created towards " + hostNameOrIp + ":" + port);
        this.requestMonitor = (RequestMonitor)monitors.newMonitor(RequestMonitor.class, ((Object)((Object)this)).getClass(), new String[0]);
    }

    public void start() {
        this.executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(((Object)((Object)this)).getClass().getSimpleName() + "@" + this.address));
        this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)this.executor, (Executor)this.executor));
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this);
        this.channelPool = new ResourcePool<Triplet<Channel, ChannelBuffer, ByteBuffer>>(this.maxUnusedChannels, (ResourcePool.CheckStrategy)new ResourcePool.CheckStrategy.TimeoutCheckStrategy(60000L, Clock.SYSTEM_CLOCK), (ResourcePool.Monitor)new LoggingResourcePoolMonitor(this.msgLog)){

            @Override
            protected Triplet<Channel, ChannelBuffer, ByteBuffer> create() {
                ChannelFuture channelFuture = Client.this.bootstrap.connect(Client.this.address);
                channelFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS);
                Triplet channel = null;
                if (channelFuture.isSuccess()) {
                    channel = Triplet.of((Object)channelFuture.getChannel(), (Object)ChannelBuffers.dynamicBuffer(), (Object)ByteBuffer.allocate(0x100000));
                    Client.this.msgLog.logMessage("Opened a new channel to " + Client.this.address, true);
                    return channel;
                }
                String msg = ((Object)((Object)Client.this)).getClass().getSimpleName() + " could not connect to " + Client.this.address;
                Client.this.msgLog.logMessage(msg, true);
                ComException exception = new ComException(msg);
                throw exception;
            }

            @Override
            protected boolean isAlive(Triplet<Channel, ChannelBuffer, ByteBuffer> resource) {
                return ((Channel)resource.first()).isConnected();
            }

            @Override
            protected void dispose(Triplet<Channel, ChannelBuffer, ByteBuffer> resource) {
                Channel channel = (Channel)resource.first();
                if (channel.isConnected()) {
                    Client.this.msgLog.debug("Closing channel: " + channel + ". Channel pool size is now " + Client.this.channelPool.currentSize());
                    channel.close();
                }
            }
        };
        this.resourcePoolReleaser = new ResourceReleaser(){

            @Override
            public void release() {
                Client.this.channelPool.release();
            }
        };
    }

    public void stop() {
        this.channelPool.close(true);
        this.bootstrap.releaseExternalResources();
        this.executor.shutdownNow();
        this.mismatchingVersionHandlers.clear();
        this.msgLog.logMessage(this.toString() + " shutdown", true);
    }

    protected <R> Response<R> sendRequest(RequestType<T> type, RequestContext context, Serializer serializer, Deserializer<R> deserializer) {
        return this.sendRequest(type, context, serializer, deserializer, null);
    }

    protected <R> Response<R> sendRequest(RequestType<T> type, RequestContext context, Serializer serializer, Deserializer<R> deserializer, StoreId specificStoreId) {
        boolean success = true;
        Triplet<Channel, ChannelBuffer, ByteBuffer> channelContext = null;
        Throwable failure = null;
        try {
            channelContext = this.getChannel(type);
            Channel channel = (Channel)channelContext.first();
            ChannelBuffer output = (ChannelBuffer)channelContext.second();
            ByteBuffer input = (ByteBuffer)channelContext.third();
            HashMap<String, String> requestContext = new HashMap<String, String>();
            requestContext.put("type", type.toString());
            requestContext.put("slaveContext", context.toString());
            requestContext.put("serverAddress", channel.getRemoteAddress().toString());
            this.requestMonitor.beginRequest(requestContext);
            this.protocol.serializeRequest(channel, output, type, context, serializer);
            Response<R> response = this.protocol.deserializeResponse((BlockingReadHandler<ChannelBuffer>)((BlockingReadHandler)channel.getPipeline().get("blockingHandler")), input, this.getReadTimeout(type, this.readTimeout), deserializer, this.resourcePoolReleaser);
            if (this.shouldCheckStoreId(type)) {
                if (specificStoreId != null) {
                    this.assertCorrectStoreId(response.getStoreId(), specificStoreId);
                } else {
                    this.assertCorrectStoreId(response.getStoreId(), this.storeId);
                }
            }
            Response<R> response2 = response;
            return response2;
        }
        catch (IllegalProtocolVersionException e) {
            failure = e;
            success = false;
            for (MismatchingVersionHandler handler : this.mismatchingVersionHandlers) {
                handler.versionMismatched(e.getExpected(), e.getReceived());
            }
            throw e;
        }
        catch (Throwable e) {
            failure = e;
            success = false;
            if (channelContext != null) {
                this.closeChannel(channelContext);
            }
            throw (ComException)Exceptions.launderedException(ComException.class, (Throwable)e);
        }
        finally {
            if (!success) {
                this.releaseChannel();
            }
            this.requestMonitor.endRequest(failure);
        }
    }

    protected long getReadTimeout(RequestType<T> type, long readTimeout) {
        return readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<T> type) {
        return true;
    }

    protected StoreId getStoreId() {
        return this.storeId;
    }

    private void assertCorrectStoreId(StoreId storeId, StoreId myStoreId) {
        if (!myStoreId.equals((Object)storeId)) {
            throw new MismatchingStoreIdException(myStoreId, storeId);
        }
    }

    private Triplet<Channel, ChannelBuffer, ByteBuffer> getChannel(RequestType<T> type) throws Exception {
        Triplet<Channel, ChannelBuffer, ByteBuffer> result = this.channelPool.acquire();
        if (result == null) {
            this.msgLog.error("Unable to acquire new channel for " + type);
            throw new ComException("Unable to acquire new channel for " + type);
        }
        return result;
    }

    private void releaseChannel() {
        this.channelPool.release();
    }

    private void closeChannel(Triplet<Channel, ChannelBuffer, ByteBuffer> channel) {
        ((Channel)channel.first()).close().awaitUninterruptibly();
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        Protocol.addLengthFieldPipes(pipeline, this.frameLength);
        BlockingReadHandler reader = new BlockingReadHandler(new ArrayBlockingQueue(3, false));
        pipeline.addLast("blockingHandler", (ChannelHandler)reader);
        return pipeline;
    }

    public void addMismatchingVersionHandler(MismatchingVersionHandler toAdd) {
        this.mismatchingVersionHandlers.add(toAdd);
    }

    protected byte getInternalProtocolVersion() {
        return 2;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.address + "]";
    }
}

