/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class HeapTrackingLongIntHashMap
extends LongIntHashMap
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongIntHashMap.class);
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    final MemoryTracker memoryTracker;
    private int trackedCapacity;

    static HeapTrackingLongIntHashMap createLongIntHashMap(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongIntHashMap.arraysHeapSize(16));
        return new HeapTrackingLongIntHashMap(memoryTracker, 16);
    }

    private HeapTrackingLongIntHashMap(MemoryTracker memoryTracker, int trackedCapacity) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingLongIntHashMap.arraysHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingLongIntHashMap.arraysHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingLongIntHashMap.arraysHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    public int size() {
        AbstractMutableIntValuesMap.SentinelValues sentinelValues = this.getSentinelValues();
        return this.getOccupiedWithData() + (sentinelValues == null ? 0 : sentinelValues.size());
    }

    static long arraysHeapSize(int arrayLength) {
        long keyArray = HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 8L));
        long valueArray = HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 4L));
        return keyArray + valueArray;
    }
}

