/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.pool;

import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;

public class LinkedQueuePool<R>
implements Pool<R> {
    private final Queue<R> unused = new ConcurrentLinkedQueue<R>();
    private final Monitor<R> monitor;
    private final int minSize;
    private final Factory<R> factory;
    private final CheckStrategy checkStrategy;
    private final AtomicInteger allocated = new AtomicInteger(0);
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private int currentPeakSize;
    private int targetSize;

    public LinkedQueuePool(int minSize, Factory<R> factory) {
        this(minSize, factory, new CheckStrategy.TimeoutCheckStrategy(Duration.ofMinutes(1L)), new Monitor.Adapter());
    }

    public LinkedQueuePool(int minSize, Factory<R> factory, CheckStrategy strategy, Monitor<R> monitor) {
        this.minSize = minSize;
        this.factory = factory;
        this.currentPeakSize = 0;
        this.targetSize = minSize;
        this.checkStrategy = strategy;
        this.monitor = monitor;
    }

    protected R create() {
        return (R)this.factory.newInstance();
    }

    protected void dispose(R resource) {
        this.monitor.disposed(resource);
        this.allocated.decrementAndGet();
    }

    @Override
    public final R acquire() {
        R resource = this.unused.poll();
        if (resource == null) {
            resource = this.create();
            this.allocated.incrementAndGet();
            this.monitor.created(resource);
        } else {
            this.queueSize.decrementAndGet();
        }
        this.currentPeakSize = Math.max(this.currentPeakSize, this.allocated.get() - this.queueSize.get());
        if (this.checkStrategy.shouldCheck()) {
            this.targetSize = Math.max(this.minSize, this.currentPeakSize);
            this.monitor.updatedCurrentPeakSize(this.currentPeakSize);
            this.currentPeakSize = 0;
            this.monitor.updatedTargetSize(this.targetSize);
        }
        this.monitor.acquired(resource);
        return resource;
    }

    @Override
    public void release(R toRelease) {
        if (this.queueSize.get() < this.targetSize) {
            this.unused.offer(toRelease);
            this.queueSize.incrementAndGet();
        } else {
            this.dispose(toRelease);
        }
    }

    @Override
    public void close() {
        R resource = this.unused.poll();
        while (resource != null) {
            this.dispose(resource);
            resource = this.unused.poll();
        }
    }

    public static interface CheckStrategy {
        public boolean shouldCheck();

        public static class TimeoutCheckStrategy
        implements CheckStrategy {
            private final long intervalNanos;
            private long lastCheckTimeNanos;
            private final LongSupplier clock;

            TimeoutCheckStrategy(Duration duration) {
                this(duration, System::nanoTime);
            }

            TimeoutCheckStrategy(Duration duration, LongSupplier nanoClock) {
                this.intervalNanos = duration.toNanos();
                this.lastCheckTimeNanos = nanoClock.getAsLong();
                this.clock = nanoClock;
            }

            @Override
            public boolean shouldCheck() {
                long currentTimeNanos = this.clock.getAsLong();
                if (currentTimeNanos > this.lastCheckTimeNanos + this.intervalNanos) {
                    this.lastCheckTimeNanos = currentTimeNanos;
                    return true;
                }
                return false;
            }
        }
    }

    public static interface Monitor<R> {
        public void updatedCurrentPeakSize(int var1);

        public void updatedTargetSize(int var1);

        public void created(R var1);

        public void acquired(R var1);

        public void disposed(R var1);

        public static class Adapter<R>
        implements Monitor<R> {
            @Override
            public void updatedCurrentPeakSize(int currentPeakSize) {
            }

            @Override
            public void updatedTargetSize(int targetSize) {
            }

            @Override
            public void created(R resource) {
            }

            @Override
            public void acquired(R resource) {
            }

            @Override
            public void disposed(R resource) {
            }
        }
    }
}

