/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.EmptyStackException;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.graphdb.Resource;

public class HeapTrackingLongStack
implements Resource {
    private final HeapTrackingLongArrayList delegate;

    public HeapTrackingLongStack(HeapTrackingLongArrayList delegate) {
        this.delegate = delegate;
    }

    public long peek() {
        int size = this.delegate.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return this.delegate.get(size - 1);
    }

    public void push(long item) {
        this.delegate.add(item);
    }

    public long pop() {
        return this.delegate.removeLast();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public void close() {
        this.delegate.close();
    }
}

