/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.CombiningIterable;
import org.neo4j.internal.helpers.collection.FilterIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapIterable;

public final class Iterables {
    private Iterables() {
        throw new AssertionError((Object)"no instance");
    }

    public static <T> Iterable<T> empty() {
        return Collections.emptyList();
    }

    public static <T> Iterable<T> emptyResourceIterable() {
        return EmptyResourceIterable.EMPTY_RESOURCE_ITERABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, C extends Collection<T>> C addAll(C collection, Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        try {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception exception) {}
            }
        }
        return collection;
    }

    public static <X> Iterable<X> filter(Predicate<? super X> specification, Iterable<X> i) {
        return new FilterIterable<X>(i, specification);
    }

    public static <X> List<X> reverse(List<X> iterable) {
        List<X> list = Iterables.asList(iterable);
        Collections.reverse(list);
        return list;
    }

    public static <FROM, TO> Iterable<TO> map(Function<? super FROM, ? extends TO> function, Iterable<FROM> from) {
        return new MapIterable<FROM, TO>(from, function);
    }

    @SafeVarargs
    public static <T, C extends T> Iterable<T> iterable(C ... items) {
        return Arrays.asList(items);
    }

    public static <T, C> Iterable<T> cast(Iterable<C> iterable) {
        return iterable;
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return Iterables.concat(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<T>> iterables) {
        return new CombiningIterable(iterables);
    }

    public static <T, C extends T> Iterable<T> append(final C item, Iterable<T> iterable) {
        return () -> {
            final Iterator iterator = iterable.iterator();
            return new Iterator<T>(){
                Object last;
                {
                    this.last = item;
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext() || this.last != null;
                }

                @Override
                public T next() {
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    try {
                        Object object = this.last;
                        return object;
                    }
                    finally {
                        this.last = null;
                    }
                }

                @Override
                public void remove() {
                }
            };
        };
    }

    public static Object[] asArray(Iterable<Object> iterable) {
        return Iterables.asArray(Object.class, iterable);
    }

    public static <T> T[] asArray(Class<T> componentType, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        List<Object> list = Iterables.asList(iterable);
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public static <T> ResourceIterable<T> asResourceIterable(Iterable<T> iterable) {
        if (iterable instanceof ResourceIterable) {
            return (ResourceIterable)iterable;
        }
        return () -> Iterators.asResourceIterator(iterable.iterator());
    }

    public static String toString(Iterable<?> values, String separator) {
        Iterator<?> it = values.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        try {
            T t = Iterators.firstOrNull(iterator);
            return t;
        }
        finally {
            if (iterator instanceof Resource) {
                ((Resource)iterator).close();
            }
        }
    }

    public static <T> T first(Iterable<T> iterable) {
        return Iterators.first(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        return Iterators.last(iterable.iterator());
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        return Iterators.singleOrNull(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable) {
        return Iterators.single(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable, T itemIfNone) {
        return Iterators.single(iterable.iterator(), itemIfNone);
    }

    public static <T> long count(Iterable<T> iterable) {
        return Iterables.count(iterable, Predicates.alwaysTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long count(Iterable<T> iterable, Predicate<T> filter) {
        Iterator<T> iterator = iterable.iterator();
        try {
            long l = Iterators.count(iterator, filter);
            return l;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)iterator).close();
            }
        }
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        return Iterables.addAll(new ArrayList(), iterable);
    }

    public static <T> List<T> asList(Iterable<T> iterator) {
        return Iterables.addAll(new ArrayList(), iterator);
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return Iterables.addAll(new HashSet(), iterable);
    }

    public static <T> Set<T> asUniqueSet(Iterable<T> iterable) {
        return Iterators.addToCollectionUnique(iterable, new HashSet());
    }

    public static Iterable<Long> asIterable(long ... array) {
        return () -> Iterators.asIterator(array);
    }

    public static Iterable<Integer> asIterable(int ... array) {
        return () -> Iterators.asIterator(array);
    }

    @SafeVarargs
    public static <T> Iterable<T> asIterable(T ... array) {
        return () -> Iterators.iterator(array);
    }

    public static <T> ResourceIterable<T> resourceIterable(Iterable<T> iterable) {
        return () -> Iterators.resourceIterator(iterable.iterator(), Resource.EMPTY);
    }

    public static <T> Iterable<T> option(T item) {
        if (item == null) {
            return Collections.emptyList();
        }
        return () -> Iterators.iterator(item);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return Iterables.stream(iterable, 0);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable, int characteristics) {
        Objects.requireNonNull(iterable);
        return Iterators.stream(iterable.iterator(), characteristics);
    }

    public static <T, E extends Exception> void safeForAll(ThrowingConsumer<T, E> consumer, Iterable<T> subjects) throws E {
        Exception exception = null;
        for (T instance : subjects) {
            try {
                consumer.accept(instance);
            }
            catch (Exception e) {
                exception = (Exception)Exceptions.chain(exception, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static class EmptyResourceIterable<T>
    implements ResourceIterable<T> {
        private static final ResourceIterable<Object> EMPTY_RESOURCE_ITERABLE = new EmptyResourceIterable<Object>();

        private EmptyResourceIterable() {
        }

        public ResourceIterator<T> iterator() {
            return Iterators.emptyResourceIterator();
        }
    }
}

