/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collection.PrefetchingRawIterator;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.helpers.collection.Iterators;

public interface RawIterator<T, EXCEPTION extends Exception> {
    public static final RawIterator<Object, Exception> EMPTY_ITERATOR = RawIterator.of(new Object[0]);

    public boolean hasNext() throws EXCEPTION;

    public T next() throws EXCEPTION;

    default public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <T, EXCEPTION extends Exception> RawIterator<T, EXCEPTION> empty() {
        return EMPTY_ITERATOR;
    }

    public static <T, EX extends Exception> RawIterator<T, EX> of(final T ... values) {
        return new RawIterator<T, EX>(){
            private int position;

            @Override
            public boolean hasNext() throws Exception {
                return this.position < values.length;
            }

            @Override
            public T next() throws Exception {
                if (this.hasNext()) {
                    return values[this.position++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <T, EX extends Exception> RawIterator<T, EX> from(final ThrowingSupplier<T, EX> supplier) {
        return new PrefetchingRawIterator<T, EX>(){

            @Override
            protected T fetchNextOrNull() throws Exception {
                return supplier.get();
            }
        };
    }

    public static <T, EX extends Exception> RawIterator<T, EX> wrap(Iterator<T> iterator) {
        return Iterators.asRawIterator(iterator);
    }
}

