/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.CombiningIterator;

public class CombiningResourceIterator<T>
extends CombiningIterator<T>
implements ResourceIterator<T> {
    private final Iterator<ResourceIterator<T>> iterators;
    private final Collection<ResourceIterator<T>> seenIterators = new ArrayList<ResourceIterator<T>>();
    private ResourceIterator<T> currentIterator;

    public CombiningResourceIterator(Iterator<ResourceIterator<T>> iterators) {
        super(iterators);
        this.iterators = iterators;
    }

    @Override
    protected Iterator<T> nextIteratorOrNull() {
        if (this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
            this.seenIterators.add(this.currentIterator);
            return this.currentIterator;
        }
        return null;
    }

    public void close() {
        for (ResourceIterator<T> seenIterator : this.seenIterators) {
            seenIterator.close();
        }
        while (this.iterators.hasNext()) {
            this.iterators.next().close();
        }
    }
}

