/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.CombiningResourceIterator;
import org.neo4j.helpers.collection.FilterIterable;
import org.neo4j.helpers.collection.MapIterable;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.helpers.collection.RawMapIterator;
import org.neo4j.helpers.collection.WrappingResourceIterator;

public final class Iterators {
    private Iterators() {
        throw new AssertionError((Object)"no instance");
    }

    public static <T> T firstOrNull(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> T first(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.firstOrNull(iterator));
    }

    public static <T> T lastOrNull(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T last(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.lastOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        return Iterators.single(iterator, null);
    }

    public static <T> T single(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.singleOrNull(iterator));
    }

    public static <T> T fromEnd(Iterator<T> iterator, int n) {
        return Iterators.assertNotNull(iterator, Iterators.fromEndOrNull(iterator, n));
    }

    public static <T> T fromEndOrNull(Iterator<T> iterator, int n) {
        ArrayDeque<T> trail = new ArrayDeque<T>(n);
        while (iterator.hasNext()) {
            if (trail.size() > n) {
                trail.removeLast();
            }
            trail.addFirst(iterator.next());
        }
        return trail.size() == n + 1 ? (T)trail.getLast() : null;
    }

    public static boolean iteratorsEqual(Iterator<?> first, Iterator<?> other) {
        while (first.hasNext() && other.hasNext()) {
            if (first.next().equals(other.next())) continue;
            return false;
        }
        return first.hasNext() == other.hasNext();
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T single(Iterator<T> iterator, T itemIfNone) {
        try {
            T result;
            T t = result = iterator.hasNext() ? iterator.next() : itemIfNone;
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
            }
            T t2 = result;
            return t2;
        }
        finally {
            if (iterator instanceof Resource) {
                ((Resource)iterator).close();
            }
        }
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            Iterators.addUnique(collection, iterator.next());
        }
        return collection;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterable<T> iterable, C collection) {
        return Iterators.addToCollectionUnique(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> loop(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator) {
        return Iterators.loop(iterator);
    }

    public static <T> long count(Iterator<T> iterator) {
        return Iterators.count(iterator, Predicates.alwaysTrue());
    }

    public static <T> long count(Iterator<T> iterator, Predicate<T> filter) {
        long result = 0L;
        while (iterator.hasNext()) {
            if (!filter.test(iterator.next())) continue;
            ++result;
        }
        return result;
    }

    public static <T> Collection<T> asCollection(Iterator<T> iterable) {
        return Iterators.addToCollection(iterable, new ArrayList());
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        return Iterators.addToCollection(iterator, new ArrayList());
    }

    public static <T, EX extends Exception> List<T> asList(RawIterator<T, EX> iterator) throws EX {
        ArrayList<T> out = new ArrayList<T>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static <T> Set<T> asSet(Iterator<T> iterator) {
        return Iterators.addToCollection(iterator, new HashSet());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... items) {
        return Iterators.asSet(items);
    }

    @SafeVarargs
    public static <T> Set<T> asUniqueSet(T ... items) {
        HashSet set = new HashSet();
        for (T item : items) {
            Iterators.addUnique(set, item);
        }
        return set;
    }

    public static <T> Set<T> asUniqueSet(Iterator<T> items) {
        HashSet set = new HashSet();
        while (items.hasNext()) {
            Iterators.addUnique(set, items.next());
        }
        return set;
    }

    public static Iterator<Long> asIterator(final long ... array) {
        return new PrefetchingIterator<Long>(){
            private int index;

            @Override
            protected Long fetchNextOrNull() {
                try {
                    Long l = this.index < array.length ? Long.valueOf(array[this.index]) : null;
                    return l;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static Iterator<Integer> asIterator(final int ... array) {
        return new PrefetchingIterator<Integer>(){
            private int index;

            @Override
            protected Integer fetchNextOrNull() {
                try {
                    Integer n = this.index < array.length ? Integer.valueOf(array[this.index]) : null;
                    return n;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> asIterator(final int maxItems, final T ... array) {
        return new PrefetchingIterator<T>(){
            private int index;

            @Override
            protected T fetchNextOrNull() {
                try {
                    Object object = this.index < array.length && this.index < maxItems ? array[this.index] : null;
                    return object;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static <T> Iterator<T> iterator(final T item) {
        if (item == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            T myItem;
            {
                this.myItem = item;
            }

            @Override
            public boolean hasNext() {
                return this.myItem != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object toReturn = this.myItem;
                this.myItem = null;
                return toReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... items) {
        return Iterators.asIterator(items.length, items);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(int maxItems, T ... items) {
        return Iterators.asIterator(maxItems, items);
    }

    public static <T> ResourceIterator<T> emptyResourceIterator() {
        return EmptyResourceIterator.EMPTY_RESOURCE_ITERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean contains(Iterator<T> iterator, T item) {
        try {
            for (T element : Iterators.loop(iterator)) {
                if (!(item == null ? element == null : item.equals(element))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)iterator).close();
            }
        }
    }

    public static <T> ResourceIterator<T> asResourceIterator(Iterator<T> iterator) {
        if (iterator instanceof ResourceIterator) {
            return (ResourceIterator)iterator;
        }
        return new WrappingResourceIterator<T>(iterator);
    }

    public static <T> ResourceIterator<T> resourceIterator(final Iterator<T> iterator, final Resource resource) {
        return new PrefetchingResourceIterator<T>(){

            public void close() {
                resource.close();
            }

            @Override
            protected T fetchNextOrNull() {
                return iterator.hasNext() ? (Object)iterator.next() : null;
            }
        };
    }

    @SafeVarargs
    public static <T> T[] array(T ... items) {
        return items;
    }

    public static <X> Iterator<X> filter(Predicate<? super X> specification, Iterator<X> i) {
        return new FilterIterable.FilterIterator<X>(i, specification);
    }

    public static <FROM, TO> Iterator<TO> map(Function<? super FROM, ? extends TO> function, Iterator<FROM> from) {
        return new MapIterable.MapIterator<FROM, TO>(from, function);
    }

    public static <FROM, TO, EX extends Exception> RawIterator<TO, EX> map(ThrowingFunction<? super FROM, ? extends TO, EX> function, RawIterator<FROM, EX> from) {
        return new RawMapIterator<FROM, TO, EX>(from, function);
    }

    public static <T, EX extends Exception> RawIterator<T, EX> asRawIterator(final Iterator<T> iter) {
        return new RawIterator<T, EX>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return iter.next();
            }
        };
    }

    public static <T, EX extends Exception> RawIterator<T, EX> asRawIterator(Stream<T> stream) {
        return Iterators.asRawIterator(stream.iterator());
    }

    public static <FROM, TO> Iterator<TO> flatMap(Function<? super FROM, ? extends Iterator<TO>> function, Iterator<FROM> from) {
        return new CombiningIterator(Iterators.map(function, from));
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        return Iterators.concat(Arrays.asList(iterators).iterator());
    }

    public static <T> ResourceIterator<T> concatResourceIterators(Iterator<ResourceIterator<T>> iterators) {
        return new CombiningResourceIterator<T>(iterators);
    }

    public static <T> Iterator<T> concat(Iterator<Iterator<T>> iterators) {
        return new CombiningIterator<T>(iterators);
    }

    public static <T> ResourceIterable<T> asResourceIterable(ResourceIterator<T> it) {
        return () -> it;
    }

    public static String join(String joinString, Iterator<?> iter) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(joinString);
        }
        return sb.toString();
    }

    public static <T> PrefetchingIterator<T> prefetching(final Iterator<T> iterator) {
        return iterator instanceof PrefetchingIterator ? (PrefetchingIterator)iterator : new PrefetchingIterator<T>(){

            @Override
            protected T fetchNextOrNull() {
                return iterator.hasNext() ? (Object)iterator.next() : null;
            }
        };
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return Iterators.stream(iterator, 0);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator, int characteristics) {
        Objects.requireNonNull(iterator);
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, characteristics);
        Stream<T> stream = StreamSupport.stream(spliterator, false);
        if (iterator instanceof Resource) {
            return (Stream)stream.onClose(() -> ((Resource)((Resource)iterator)).close());
        }
        return stream;
    }

    private static class EmptyResourceIterator<E>
    implements ResourceIterator<E> {
        private static final ResourceIterator<Object> EMPTY_RESOURCE_ITERATOR = new EmptyResourceIterator<Object>();

        private EmptyResourceIterator() {
        }

        public void close() {
        }

        public boolean hasNext() {
            return false;
        }

        public E next() {
            throw new NoSuchElementException();
        }
    }
}

