/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.codegen.ByteCodeVisitor;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.internal.unsafe.UnsafeUtil;

class CodeLoader
extends ClassLoader {
    private final Map<String, ByteCodes> stagedClasses = new HashMap<String, ByteCodes>();

    CodeLoader(ClassLoader parent) {
        super(parent);
    }

    synchronized void stageForLoading(Iterable<? extends ByteCodes> classes, ByteCodeVisitor visitor) {
        for (ByteCodes byteCodes : classes) {
            visitor.visitByteCode(byteCodes.name(), byteCodes.bytes().duplicate());
            this.stagedClasses.put(byteCodes.name(), byteCodes);
        }
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        ByteCodes clazz = this.stagedClasses.remove(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        if (this.getDefinedPackage(packageName) == null) {
            this.definePackage(packageName, "", "", "", "", "", "", null);
        }
        return this.defineClass(name, clazz.bytes(), null);
    }

    protected synchronized Class<?> defineAnonymousClass(String name) throws Throwable {
        ByteCodes clazz = this.stagedClasses.remove(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return UnsafeUtil.defineAnonymousClass(CodeLoader.class, (ByteBuffer)clazz.bytes());
    }
}

