/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.lang.reflect.Modifier;
import java.util.List;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.Configuration;
import org.neo4j.codegen.source.MethodSourceWriter;

class ClassSourceWriter
implements ClassEmitter {
    private final StringBuilder target;
    final Configuration configuration;

    ClassSourceWriter(StringBuilder target, Configuration configuration) {
        this.target = target;
        this.configuration = configuration;
    }

    void declarePackage(TypeReference type) {
        this.append("package ").append(type.packageName()).append(";\n");
    }

    void javadoc(String javadoc) {
        this.append("/** ").append(javadoc).append(" */\n");
    }

    void publicClass(TypeReference type) {
        this.append("public class ").append(type.simpleName());
    }

    void extendClass(TypeReference base) {
        this.append(" extends ").append(base.name()).append("\n");
    }

    void implement(TypeReference[] interfaces) {
        String prefix = "    implements ";
        for (TypeReference iFace : interfaces) {
            this.append(prefix).append(iFace.name());
            prefix = ", ";
        }
        if (prefix.length() == 2) {
            this.append("\n");
        }
    }

    void begin() {
        this.append("{\n");
    }

    @Override
    public MethodEmitter method(MethodDeclaration signature) {
        StringBuilder target = new StringBuilder();
        if (signature.isConstructor()) {
            if (signature.isStatic()) {
                target.append("    static\n    {\n");
                return new MethodSourceWriter(target, this);
            }
            target.append("    ").append(Modifier.toString(signature.modifiers())).append(" ");
            ClassSourceWriter.typeParameters(target, signature);
            target.append(signature.declaringClass().simpleName());
        } else {
            target.append("    ").append(Modifier.toString(signature.modifiers())).append(" ");
            ClassSourceWriter.typeParameters(target, signature);
            target.append(signature.returnType().name()).append(" ").append(signature.name());
        }
        target.append("(");
        String prefix = " ";
        for (Parameter parameter : signature.parameters()) {
            target.append(prefix).append(parameter.type().name()).append(" ").append(parameter.name());
            prefix = ", ";
        }
        if (prefix.length() > 1) {
            target.append(" ");
        }
        target.append(')');
        String sep = " throws ";
        for (TypeReference thrown : signature.throwsList()) {
            target.append(sep).append(thrown.name());
            sep = ", ";
        }
        target.append("\n    {\n");
        return new MethodSourceWriter(target, this);
    }

    private static void typeParameters(StringBuilder target, MethodDeclaration method) {
        List<MethodDeclaration.TypeParameter> parameters = method.typeParameters();
        if (!parameters.isEmpty()) {
            target.append('<');
            String sep = "";
            for (MethodDeclaration.TypeParameter parameter : parameters) {
                target.append(sep).append(parameter.name());
                TypeReference ext = parameter.extendsBound();
                TypeReference sup = parameter.superBound();
                if (ext != null) {
                    target.append(" extends ").append(ext.name());
                } else if (sup != null) {
                    target.append(" super ").append(sup.name());
                }
                sep = ", ";
            }
            target.append("> ");
        }
    }

    @Override
    public void done() {
        this.append("}\n");
    }

    @Override
    public void field(FieldReference field, Expression value) {
        String modifiers = Modifier.toString(field.modifiers());
        this.append("    ").append(modifiers);
        if (!modifiers.isEmpty()) {
            this.append(" ");
        }
        this.append(field.type().name()).append(' ').append(field.name());
        if (value != null) {
            this.append(" = ");
            value.accept(new MethodSourceWriter(this.target, this));
        }
        this.append(";\n");
    }

    StringBuilder append(CharSequence chars) {
        return this.target.append(chars);
    }
}

