/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.statemachine;

import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatState;
import org.neo4j.cluster.statemachine.StateTransition;
import org.neo4j.cluster.statemachine.StateTransitionListener;
import org.neo4j.helpers.Strings;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StateTransitionLogger
implements StateTransitionListener {
    private final LogProvider logProvider;
    private AtomicBroadcastSerializer atomicBroadcastSerializer;
    private String lastLogMessage = "";

    public StateTransitionLogger(LogProvider logProvider, AtomicBroadcastSerializer atomicBroadcastSerializer) {
        this.logProvider = logProvider;
        this.atomicBroadcastSerializer = atomicBroadcastSerializer;
    }

    @Override
    public void stateTransition(StateTransition transition) {
        Log log = this.logProvider.getLog(transition.getOldState().getClass());
        if (log.isDebugEnabled()) {
            String msg;
            Object payload;
            if (transition.getOldState() == HeartbeatState.heartbeat) {
                return;
            }
            String state = transition.getOldState().getClass().getSuperclass().getSimpleName();
            StringBuilder line = new StringBuilder(state).append(": ").append(transition);
            if (transition.getMessage().hasHeader("from")) {
                line.append(" from:").append(transition.getMessage().getHeader("from"));
            }
            if (transition.getMessage().hasHeader("instance")) {
                line.append(" instance:").append(transition.getMessage().getHeader("instance"));
            }
            if (transition.getMessage().hasHeader("conversation-id")) {
                line.append(" conversation-id:").append(transition.getMessage().getHeader("conversation-id"));
            }
            if ((payload = transition.getMessage().getPayload()) != null) {
                if (payload instanceof Payload) {
                    try {
                        payload = this.atomicBroadcastSerializer.receive((Payload)payload);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                line.append(" payload:").append(Strings.prettyPrint(payload));
            }
            if ((msg = line.toString()).equals(this.lastLogMessage)) {
                return;
            }
            log.debug(line.toString());
            this.lastLogMessage = msg;
        }
    }
}

