/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.snapshot.SnapshotProvider;

public enum SnapshotMessage implements MessageType
{
    join,
    leave,
    setSnapshotProvider,
    refreshSnapshot,
    sendSnapshot,
    snapshot;


    public static class SnapshotState
    implements Serializable {
        private static final long serialVersionUID = 1518479578399690929L;
        private long lastDeliveredInstanceId = -1L;
        transient SnapshotProvider provider;
        private transient ObjectOutputStreamFactory objectOutputStreamFactory;
        transient byte[] buf;

        public SnapshotState(long lastDeliveredInstanceId, SnapshotProvider provider, ObjectOutputStreamFactory objectOutputStreamFactory) {
            this.lastDeliveredInstanceId = lastDeliveredInstanceId;
            this.provider = provider;
            if (objectOutputStreamFactory == null) {
                throw new RuntimeException("objectOutputStreamFactory was null");
            }
            this.objectOutputStreamFactory = objectOutputStreamFactory;
        }

        public long getLastDeliveredInstanceId() {
            return this.lastDeliveredInstanceId;
        }

        public void setState(SnapshotProvider provider, ObjectInputStreamFactory objectInputStreamFactory) throws IOException {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.buf);
            try (ObjectInputStream oin = objectInputStreamFactory.create(bin);){
                provider.setState(oin);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = this.objectOutputStreamFactory.create(bout);
            this.provider.getState(oout);
            oout.close();
            byte[] buf = bout.toByteArray();
            out.writeInt(buf.length);
            out.write(buf);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.buf = new byte[in.readInt()];
            try {
                in.readFully(this.buf);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }
}

