/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.election;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.ConfigurationContext;
import org.neo4j.cluster.protocol.LoggingContext;
import org.neo4j.cluster.protocol.TimeoutsContext;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.election.ElectionCredentials;
import org.neo4j.cluster.protocol.election.ElectionRole;

public interface ElectionContext
extends TimeoutsContext,
LoggingContext,
ConfigurationContext {
    public void created();

    public List<ElectionRole> getPossibleRoles();

    public void nodeFailed(InstanceId var1);

    public Iterable<String> getRoles(InstanceId var1);

    public boolean isElectionProcessInProgress(String var1);

    public void startElectionProcess(String var1);

    public boolean voted(String var1, InstanceId var2, ElectionCredentials var3, long var4);

    public InstanceId getElectionWinner(String var1);

    public ElectionCredentials getCredentialsForRole(String var1);

    public int getVoteCount(String var1);

    public int getNeededVoteCount();

    public void forgetElection(String var1);

    public Iterable<String> getRolesRequiringElection();

    public boolean electionOk();

    public boolean isInCluster();

    public Iterable<InstanceId> getAlive();

    public boolean isElector();

    public boolean isFailed(InstanceId var1);

    public InstanceId getElected(String var1);

    public boolean hasCurrentlyElectedVoted(String var1, InstanceId var2);

    public Set<InstanceId> getFailed();

    public ClusterMessage.VersionedConfigurationStateChange newConfigurationStateChange();

    public VoteRequest voteRequestForRole(ElectionRole var1);

    public static class VoteRequest
    implements Serializable {
        private static final long serialVersionUID = -715604979485263049L;
        private String role;
        private long version;

        public VoteRequest(String role, long version) {
            this.role = role;
            this.version = version;
        }

        public String getRole() {
            return this.role;
        }

        public long getVersion() {
            return this.version;
        }

        public String toString() {
            return "VoteRequest{role='" + this.role + "', version=" + this.version + "}";
        }
    }
}

