/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.Vote;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.WinnerStrategy;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.ElectionContextImpl;
import org.neo4j.cluster.protocol.cluster.ClusterContext;

public class DefaultWinnerStrategy
implements WinnerStrategy {
    private ClusterContext electionContext;

    public DefaultWinnerStrategy(ClusterContext electionContext) {
        this.electionContext = electionContext;
    }

    @Override
    public InstanceId pickWinner(Collection<Vote> votes) {
        List<Vote> eligibleVotes = ElectionContextImpl.removeBlankVotes(votes);
        this.moveMostSuitableCandidatesToTop(eligibleVotes);
        this.logElectionOutcome(votes, eligibleVotes);
        Iterator<Vote> iterator = eligibleVotes.iterator();
        if (iterator.hasNext()) {
            Vote vote = iterator.next();
            return vote.getSuggestedNode();
        }
        return null;
    }

    private void moveMostSuitableCandidatesToTop(List<Vote> eligibleVotes) {
        Collections.sort(eligibleVotes);
        Collections.reverse(eligibleVotes);
    }

    private void logElectionOutcome(Collection<Vote> votes, List<Vote> eligibleVotes) {
        String electionOutcome = String.format("Election: received votes %s, eligible votes %s", votes, eligibleVotes);
        this.electionContext.getLog(this.getClass()).debug(electionOutcome);
    }
}

