/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.io.Serializable;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;

public enum AcceptorMessage implements MessageType
{
    failure,
    join,
    leave,
    prepare,
    accept;


    public static class AcceptState
    implements Serializable {
        private static final long serialVersionUID = -5510569299948660967L;
        private long ballot;
        private Object value;

        public AcceptState(long ballot, Object value) {
            this.ballot = ballot;
            this.value = value;
        }

        public long getBallot() {
            return this.ballot;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AcceptState that = (AcceptState)o;
            if (this.ballot != that.ballot) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = (int)(this.ballot ^ this.ballot >>> 32);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            Object toStringValue = this.value;
            if (toStringValue instanceof Payload) {
                try {
                    toStringValue = new AtomicBroadcastSerializer(new ObjectStreamFactory(), new ObjectStreamFactory()).receive((Payload)toStringValue);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return "AcceptState{ballot=" + this.ballot + ", value=" + toStringValue + "}";
        }
    }

    public static class PrepareState
    implements Serializable {
        private static final long serialVersionUID = 7179066752672770593L;
        private long ballot;

        public PrepareState(long ballot) {
            this.ballot = ballot;
        }

        public long getBallot() {
            return this.ballot;
        }

        public String toString() {
            return "PrepareState{ballot=" + this.ballot + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrepareState that = (PrepareState)o;
            return this.ballot == that.ballot;
        }

        public int hashCode() {
            return (int)(this.ballot ^ this.ballot >>> 32);
        }
    }
}

