/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class Payload
implements Externalizable {
    private byte[] buf;
    private int len;

    public Payload() {
    }

    public Payload(byte[] buf, int len) {
        this.buf = buf;
        this.len = len;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public int getLen() {
        return this.len;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.len);
        out.write(this.buf, 0, this.len);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.len = in.readInt();
        this.buf = new byte[this.len];
        in.read(this.buf, 0, this.len);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload payload = (Payload)o;
        if (this.len != payload.len) {
            return false;
        }
        return Arrays.equals(this.buf, payload.buf);
    }

    public int hashCode() {
        int result = this.buf != null ? Arrays.hashCode(this.buf) : 0;
        result = 31 * result + this.len;
        return result;
    }
}

