/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.member.paxos;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import org.neo4j.cluster.InstanceId;

public class MemberIsUnavailable
implements Externalizable {
    private String role;
    private InstanceId instanceId;
    private URI clusterUri;

    public MemberIsUnavailable() {
    }

    public MemberIsUnavailable(String role, InstanceId instanceId, URI clusterUri) {
        this.role = role;
        this.instanceId = instanceId;
        this.clusterUri = clusterUri;
    }

    public String getRole() {
        return this.role;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.role);
        out.writeObject(this.instanceId);
        if (this.clusterUri != null) {
            out.writeUTF(this.clusterUri.toString());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.role = in.readUTF();
        this.instanceId = (InstanceId)in.readObject();
        if (in.available() != 0) {
            this.clusterUri = URI.create(in.readUTF());
        }
    }

    public String toString() {
        return String.format("MemberIsUnavailable[ Role: %s, InstanceId: %s, ClusterURI: %s ]", this.role, this.instanceId.toString(), this.clusterUri == null ? null : this.clusterUri.toString());
    }
}

