/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.member.paxos;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.kernel.impl.store.StoreId;

public class MemberIsAvailable
implements Externalizable {
    private String role;
    private InstanceId instanceId;
    private URI clusterUri;
    private URI roleUri;
    private StoreId storeId;

    public MemberIsAvailable() {
    }

    public MemberIsAvailable(String role, InstanceId instanceId, URI clusterUri, URI roleUri, StoreId storeId) {
        this.role = role;
        this.instanceId = instanceId;
        this.clusterUri = clusterUri;
        this.roleUri = roleUri;
        this.storeId = storeId;
    }

    public String getRole() {
        return this.role;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    public URI getRoleUri() {
        return this.roleUri;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.role);
        out.writeObject(this.instanceId);
        out.writeUTF(this.clusterUri.toString());
        out.writeUTF(this.roleUri.toString());
        this.storeId.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.role = in.readUTF();
        this.instanceId = (InstanceId)in.readObject();
        this.clusterUri = URI.create(in.readUTF());
        this.roleUri = URI.create(in.readUTF());
        try {
            this.storeId = StoreId.from((ObjectInput)in);
        }
        catch (IOException e) {
            this.storeId = StoreId.DEFAULT;
        }
    }

    public String toString() {
        return String.format("MemberIsAvailable[ Role: %s, InstanceId: %s, Role URI: %s, Cluster URI: %s]", this.role, this.instanceId.toString(), this.roleUri.toString(), this.clusterUri.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberIsAvailable that = (MemberIsAvailable)o;
        if (!this.clusterUri.equals(that.clusterUri)) {
            return false;
        }
        if (!this.instanceId.equals(that.instanceId)) {
            return false;
        }
        if (!this.role.equals(that.role)) {
            return false;
        }
        return this.roleUri.equals(that.roleUri);
    }

    public int hashCode() {
        int result = this.role.hashCode();
        result = 31 * result + this.instanceId.hashCode();
        result = 31 * result + this.clusterUri.hashCode();
        result = 31 * result + this.roleUri.hashCode();
        return result;
    }
}

