/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.function.Factory;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class ExecutorLifecycleAdapter
implements Lifecycle,
Executor {
    private ExecutorService executor;
    private Factory<ExecutorService> executorServiceFactory;

    public ExecutorLifecycleAdapter(Factory<ExecutorService> executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        this.executor = (ExecutorService)this.executorServiceFactory.newInstance();
    }

    public void stop() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            this.executor = null;
        }
    }

    public void shutdown() throws Throwable {
    }

    @Override
    public void execute(Runnable command) {
        if (this.executor != null) {
            this.executor.execute(command);
        } else {
            command.run();
        }
    }
}

